package order.vo;

import lombok.Data;

import java.io.Serializable;
import java.util.Objects;

/**
 * @author Liang Wenxu
 * @since 2018/7/12
 */
@Data
public class OrderKey implements Serializable {
    /**
     * 订单id，查询时此参数与orderNo任选其一
     */
    protected String orderId;

    /**
     * 订单号，查询时此参数与orderId任选其一
     */
    protected String orderNo;

    public OrderKey(String orderId) {
        this.orderId = orderId;
    }

    public OrderKey(String orderId, String orderNo) {
        this.orderId = orderId;
        this.orderNo = orderNo;
    }

    public OrderKey() {
    }

    public boolean isEmpty() {
        return (orderId == null || orderId.trim().length() == 0) && (orderNo == null || orderNo.trim().length() == 0);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof OrderKey)) return false;
        OrderKey key = (OrderKey) o;
        return Objects.equals(orderId, key.orderId) &&
                Objects.equals(orderNo, key.orderNo);
    }

    @Override
    public int hashCode() {

        return Objects.hash(orderId, orderNo);
    }
}
