package order.vo;

import lombok.Data;
import order.Contants;

import java.io.Serializable;

/**
 * @author Liang Wenxu
 * @since 2018/7/9
 */
@Data
public class OrderPayConfirmResp implements Serializable {
    /**
     * 是否处理成功
     */
    private Boolean success;
    /**
     * 当success为false时不为空时有意义，返回错误代码及信息
     */
    private Contants.ORDER_PAY_CONFIRM_ERROR errorCode;

    /**
     * 错误信息
     */
    private String message;

    public String getMessage() {
        return message != null && message.trim().length() > 0 ? message : errorCode.getMessage();
     }
}
