package order.vo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author Liang Wenxu
 * @since 2018/8/8
 */
@Data
public class OrderPaymentVo implements Serializable {
    /**
     * {@value}待支付
     */
    public final static String PAY_STATUS_WAIT_TO_PAY = "0"; // 待支付
    /**
     * {@value}已支付
     */
    public final static String PAY_STATUS_PAID = "1"; // 已支付
    /**
     * {@value}支付出错
     */
    public final static String PAY_STATUS_ERROR = "2"; // 支付出错
    /**
     * {@value}支付出错
     */
    public final static String PAY_STATUS_CANCAL_AND_BACK = "3"; // 支付出错

    protected String id;

    /**
     * 所使用的支付方式
     */
    private String payMethod;

    /**
     * 支付方式名称
     */
    private String payMethodName;

    /**
     * 支付类型，付款，退款 等
     */
    private String type;

    /**
     * 金额
     */
    private BigDecimal money;

    /**
     * 消耗积分
     */
    private BigDecimal score;

    /**
     * 积分扣减交易凭证号
     */
    private String rcptCode;

    /**
     * 店铺的id
     */
    private String storeId;

    /**
     * 付款用户id
     */
    private String userId;

    /**
     * 支付时使用优惠券id
     */
    private String couponId;

    /**
     * 帐户余额使用记录id
     */
    private String moneyHisId;

    /**
     * 积分使用id
     */
    private String creditsHisId;

    /**
     * 退款记录id
     */
    private String returnId;

    /**
     * 订单ID
     */
    private String orderId;

    /**
     * 支付状态代码： 0-- 待支付, 1-- 已支付, 2-- 支付出错
     */
    private String status;
}
