package order.vo;

import lombok.Data;
import utils.GlobalContants;

import java.io.Serializable;

/**
 * @author Liang Wenxu
 * @since 2018/7/12
 */
@Data
public class OrderStatus extends OrderKey implements Serializable {
    public OrderStatus(String orderId, GlobalContants.ORDER_STATUS status) {
        super(orderId);
        this.status = status;
    }

    public OrderStatus(String orderId, String orderNo, GlobalContants.ORDER_STATUS status) {
        super(orderId, orderNo);
        this.status = status;
    }

    public OrderStatus(GlobalContants.ORDER_STATUS status) {
        this.status = status;
    }

    public OrderStatus() {

    }

    /**
     * 订单状态
     */
    private GlobalContants.ORDER_STATUS status;
}
