package order.vo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 订单金额
 * @author Liang Wenxu
 * @since 2018/7/24
 */
@Data
public class OrderSumItemPrices implements Serializable {
    /**
     * 订单总价（实际应付总价，不含运费）
     */
    private BigDecimal sumPrice;

    /**
     * 订单总市场价
     */
    private BigDecimal sumMarketPrice;

    /**
     * 订单总成本价
     */
    private BigDecimal sumCostPrice;

    /**
     * 订单总原始销售价
     */
    private BigDecimal sumOrginalPrice;

    /**
     * 订单应收总价（含运费）
     */
    private BigDecimal needPayPrice;

    /**
     * 订单总运费
     */
    private BigDecimal sumShippingFee;
}
