package order.vo;

import lombok.Data;

import java.io.Serializable;

/**
 * 订单操作模板配置的唯一Key
 * @author Liang Wenxu
 * @since 2018/7/11
 */
@Data
public class OrderTemplateConfigKey implements Serializable {

    public static final String PROTOCOL_TEMPLATE_NAME = "mallProtocolOrderTemplate";

    /**
     * 订单模式，normal | batch 常规订单 | 批量订单 等
     */
    public String orderMode;

    /**
     * 商品类型，如一次购买多个类型商品，实际要分别调用其对应的Template
     */
    public String goodsType;

    /**
     * 渠道代码
     */
    public String orgCode;

    /**
     * 订单处理模板名（用作处理模板类的BeanName）
     */
    public String templateName;
}
