package order.vo;

import java.util.HashMap;
import java.util.Map;

/**
 * @author torvalds on 2018/4/17 15:55.
 * @version 1.0
 */
public enum OrderType {
    general("0", "普通订单"), protocol("1", "协议订单"), bidding("2", "竞价订单");
    public static Map<String, OrderType> orderTypeMap = new HashMap<>();

    static {
        orderTypeMap.put(general.getCode(), general);
        orderTypeMap.put(protocol.getCode(), protocol);
        orderTypeMap.put(bidding.getCode(), bidding);
    }

    private String code;
    private String description;

    OrderType(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}
