package order.vo;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 主订单
 * <p>在生成订单后，订单会按照规则拆分，最终形成一个主单，从属N个子单的情景，如没有拆分，则主单和子单为1:1关系</p>
 * @author Liang Wenxu
 * @since 2018/7/9
 */
@Data
public class ParentOrderVo extends OrderKey implements Serializable {
    /**
     * 临时订单号
     */
    private String tempOrderNo;
    /**
     * 父订单号
     */
    private String pOrder;

    /**
     * 是否前往支付标志（用于集采或不需支付环节的订单），为true时跳转支付
     */
    private Boolean gotoPay;

    /**
     * 从属的子单
     */
    private List<OrderVo> cOrders;
}
