package order.vo;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 用于去下单时的购物车信息，商城下单可从当前购物车数据中提取；批量下单、工会礼包等下单时直接从商品数据组装即可
 * @author Liang Wenxu
 * @since 2018/7/12
 */
@Data
public class SubmitedBuyerCart implements Serializable {
    /**
     * 订单模式
     */
    private String orderMode;
    /**
     * 持久化开关，当为true时会将生成的TempOrder
     */
    private Boolean persistence;
    /**
     * 渠道代码
     */
    private String organizationCode;
    /**
     * 用户的ID
     */
    private String userId;
    /**
     * 会员id
     */
    private String memberId;
    /**
     * 会员地址表id
     */
    private String memberAddressId;

    /**
     * 会员地址编号
     */
    private String memberAddressNo;
    /**
     * 收件人省市码（用于判断库存）
     */
    private String provinceCode;
    private String cityCode;
    private String townCode;
    private String countryCode;
    /**
     * 收件人详细地址（可选，若提供则赋值到返回的TempOrderVo相应字段）
     */
    private String addressDetail;
    /**
     * 会员地址全地址（可选，若提供则赋值到返回的TempOrderVo相应字段）
     */
    private String memberAddress;
    /**
     * 发票信息（整体可选，若提供则赋值到返回的TempOrderVo相应字段）
     */
    private BuyerInvoiceInfo buyerInvoiceInfo;
    /**
     * 待购商品清单
     */
    private List<BuyerCartItem> items;
}
