package order.vo;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 临时订单创建请求封装
 * @author Liang Wenxu
 * @since 2018/7/13
 */
@Data
public class TempOrderCreateRequest implements Serializable {

    /**
     * 请求ID，防重复提交
     */
    private String requestId;
    /**
     * 订单模式
     */
    private String orderMode;
    /**
     * 持久化开关，当为true时会将生成的TempOrder
     */
    private Boolean persistence;
    /**
     * 渠道代码
     */
    private String organizationCode;

    /**
     * 商品类型，如一次购买多个类型商品，实际要分别调用其对应的Template
     */
    public String goodsType;

    /**
     * 渠道ID
     */
    private String orgainzationId;

    /**
     * 用户的ID
     */
    private String userId;
    /**
     * 会员id
     */
    private String memberId;
    /**
     * 会员地址表id
     */
    private String memberAddressId;

    /**
     * 会员地址编号
     */
    private String memberAddressNo;
    /**
     * 收件人省市码（用于判断库存）
     */
    private String provinceCode;
    /**
     * 收件人市代码
     */
    private String cityCode;
    /**
     * 收件人区/县代码
     */
    private String countyCode;
    /**
     * 收件人街道/乡镇代码
     */
    private String townCode;

    /**
     * 收件人详细地址（可选，若提供则赋值到返回的TempOrderVo相应字段）
     */
    private String addressDetail;
    /**
     * 会员地址全地址（可选，若提供则赋值到返回的TempOrderVo相应字段）
     */
    private String memberAddress;

    /**
     * 浏览器userAgent原文
     * <p>可通过request.getHeader("USER-AGENT").toLowerCase();获取</p>
     */
    private String userAgent;

    /**
     * 是否进行库存校验，当为true时如临时订单中包含了无货商品会抛出{@link order.exceptions.NoStockException}
     */
    private Boolean checkStock;

    /**
     * 发票信息（可选，若提供则赋值到返回的TempOrderVo相应字段）
     */
    private List<TempInvoiceVo> tempInvoiceVos;
    /**
     * 下单商品清单
     */
    private List<GoodsInfoVo> goodsInfoVos;
}
