package order.vo;

import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 临时订单项目VO
 * Created by Liang Wenxu on 2017/1/19.
 */
@Data
public class TempOrderItemVo implements Serializable {

    private String storeId;

    private String storeCode;

    private String storeType;

    private String productId;

    private String productCode;

    private String productFashionId;

    private String goodsId;

    /**
     * 产品名称
     */
    private String fashionTitle;

    /**
     * 购买数量
     */
    private Integer count;

    /**
     * 商品上下架：1-上架；0-下架
     */
    private String upDownFlag;

    /**
     * 状态 1-- 正常 2-- 已下架/无法购买 99-- 库存状态未知（预留）
     */
    private String status;

    /**
     * 展示图片url
     */
    private String fashionPic;

    /**
     * 单价
     */
    private BigDecimal salePrice;

    /**
     * 原始商品售价，当存在主、配件组合时，此价格为主商品价格
     */
    private BigDecimal orginSalePrice;

    /**
     * 协议价
     */
    private BigDecimal costPrice;

    /**
     * 协议价合计
     */
    private BigDecimal sumCostPrice;

    /**
     * 商品总价合计（单价*数量）
     */
    private BigDecimal sumSalePrice;

    /**
     * 商品市场价
     *
     * @return
     */
    private BigDecimal marketPrice;

    /**
     * 商品市场价合计
     *
     * @return
     */
    private BigDecimal sumMarketPrice;

    /**
     * 销售价格浮动费率
     */
    private BigDecimal salesPriceRate;

    /**
     * 消费积分值
     */
    private BigDecimal historyCostScore;

    /**
     * 规格名称，用于展示名称
     */
    private String fieldName;

    /**
     * 规格代码
     */
    private String fieldCode;

    /**
     * 数据类型
     * 1为文字 2为图片
     */
    private String fieldType;

    /**
     * 规格值
     */
    private String value;

    /**
     * 规格值名称
     */
    private String valueName;

    /**
     * 库存数量
     */
    private Long stockCount;

    /**
     * 库存预警
     */
    private Integer lackRemind;

    private String  activityId ;

    /**
     * 产品类型，见GlobalContants.PRODUCT_TYPE_开头常量
     */
    private String productType;

    /**
     * 增加业务码 2018-5-30(竞价优化需求这里用作与需求编号，后期也可适用其他业务码)
     */
    private String businessCode;

    /**
     * 商品 sku
     */
    @Getter
    @Setter
    private String sku;

    /**
     * 关联的配件/从属产品
     */
    private List<TempOrderItemVo> children;

    /**
     * 重新计算各项总价，在单价设值后调用
     */
    public void recalateSumPrices() {
        BigDecimal salePrice = getSalePrice() == null ? new BigDecimal(0) : getSalePrice();
        this.sumSalePrice = salePrice.multiply(BigDecimal.valueOf(this.getCount()));

        BigDecimal marketPrice = getMarketPrice() == null ? new BigDecimal(0) : getMarketPrice();
        this.sumMarketPrice = marketPrice.multiply(BigDecimal.valueOf(this.getCount()));

        BigDecimal costPrice = getCostPrice() == null ? new BigDecimal(0) : getCostPrice();
        this.sumCostPrice = costPrice.multiply(BigDecimal.valueOf(this.getCount()));
    }


    public void setCount(Integer count) {
        this.count = count;
        this.count = this.count == null ? 1 : this.count;
    }
}
