package order.vo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 临时订单店铺Vo
 * Created by Liang Wenxu on 2017/1/23.
 */
public class TempOrderStoreVo implements Serializable {
    /**
     * 店铺ID
     */
    private String storeId;
    /**
     * 店铺名
     */
    private String storeName;
    /**
     * 店铺简称
     */
    private String shortName;
    /**
     * 店铺代码
     */
    private String code;

    /**
     * 店铺类型代码，同StoreExt的type
     */
    private String type;

    /**
     * 域名
     */
    private String domain;
    /**
     * 店铺路径
     */
    private String storePath;
    /**
     * 店铺logo图片
     */
    private String logoImg;

    /**
     * 店铺总金额合计
     */
    private BigDecimal sumPrice;
    /**
     * 店铺费率总金额合计
     */
    private BigDecimal sumRatePrice;
    /**
     * 店铺总市场价金额合计
     */
    private BigDecimal sumMarketPrice;

    /**
     * 运费
     */
    private BigDecimal shippingFee;

    /**
     * 临时订单商品
     */
    private List<TempOrderItemVo> orderItems;


    public String getStoreId() {
        return storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public String getShortName() {
        return shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String getCode() {
        return code;
    }

    public BigDecimal getSumRatePrice() {
        return sumRatePrice;
    }

    public void setSumRatePrice(BigDecimal sumRatePrice) {
        this.sumRatePrice = sumRatePrice;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getStorePath() {
        return storePath;
    }

    public void setStorePath(String storePath) {
        this.storePath = storePath;
    }

    public String getLogoImg() {
        return logoImg;
    }

    public void setLogoImg(String logoImg) {
        this.logoImg = logoImg;
    }

    public List<TempOrderItemVo> getOrderItems() {
        return orderItems;
    }

    public void setOrderItems(List<TempOrderItemVo> orderItems) {
        this.orderItems = orderItems;
    }

    public BigDecimal getSumPrice() {
        sumPrice = BigDecimal.valueOf(0);
        for(TempOrderItemVo item : this.getOrderItems()) {
            sumPrice = sumPrice.add(item.getSumSalePrice());
            // 配件价格已在生成时计算完毕
//            if(item.getChildren() != null) {
//                for(TempOrderItemVo citem : item.getChildren()) {
//                    if(citem != null) {
//                        sumPrice = sumPrice.add(citem.getSumSalePrice());
//                    }
//                }
//            }
        }
        return sumPrice;
    }

    public void setSumPrice(BigDecimal sumPrice) {
        this.sumPrice = sumPrice;
    }

    public BigDecimal getSumMarketPrice() {
        return sumMarketPrice;
    }

    public void setSumMarketPrice(BigDecimal sumMarketPrice) {
        this.sumMarketPrice = sumMarketPrice;
    }

    public BigDecimal getShippingFee() {
        return shippingFee;
    }

    public void setShippingFee(BigDecimal shippingFee) {
        this.shippingFee = shippingFee;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }
}
