package order.vo;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 临时订单Vo
 * <p>临时订单的拆分规则：主单->店铺订单->店铺个性订单（如实物商品、虚拟商品、生鲜、服务）</p>
 * Created by Liang Wenxu on 2017/1/19.
 */
@Data
public class TempOrderVo implements Serializable {
    /**
     * 临时订单号
     */
    private String tmpOrderNo;

    /**
     * 支付方式代码
     */
    private String payMethodCode;

    /**
     * 用户id
     */
    private String userId;

    /**
     * 会员id
     */
    private String memberId;

    /**
     * 创建时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /**
     * 订单总价（实际应付总价，不含运费）
     */
    private BigDecimal sumPrice;

    /**
     * 订单总市场价
     */
    private BigDecimal sumMarketPrice;

    /**
     * 订单总成本价
     */
    private BigDecimal sumCostPrice;

    /**
     * 订单总原始销售价
     */
    private BigDecimal sumOrginalPrice;

    /**
     * 订单应收总价（含运费）
     */
    private BigDecimal needPayPrice;

    /**
     * 订单总运费
     */
    private BigDecimal sumShippingFee;

    private Boolean isFreeShippingFee = false;

    /**
     * 临时订单商品
     * <p>当该临时订单是父订单时将包括所有子订单的商品</p>
     */
    private List<TempOrderItemVo> orderItems;

    /**
     * 子订单
     * <p>当该临时订单是父订单时此字段有值</p>
     */
    private List<TempSubOrderVo> subOrders;

    /**
     * 订单礼品
     */
    private List<TmpOrderGiftVo> tmpOrderGifts;

    /**
     * 订单扩展属性
     */
    private List<OrderAttrVo> orderAttrs;

    /**
     * 订单使用的优惠券
     */
    private List<OrderCouponVo> orderCouponVos;

    /**
     * 判断是否使用积分兑换 1是  0否
     */
    private String useScore;

    /**
     * 订单用途代码
     */
    private String usageCode;

    /**
     * 下单地区
     */
    private String areaCode;

    /**
     * 地区代码序列，下标0为省，下标4为街道/乡镇
     */
    private List<String> areaCodeList;

    /**
     * 一个临时订单对应多个发票
     */
    private List<TempInvoiceVo> tempInvoiceVos;

    /**
     * 积分抵扣金额
     */
    private BigDecimal socrePrice;

    /**
     * 来源渠道代码
     */
    private String organizationCode;

    /**
     * 来源渠道表id
     */
    private String realOrganizationId;

    /**
     * 购买类型 ipad,mobile,pc
     */

    private String buyType;

    /**
     * 用来记录网页头信息
     */

    private String headMessage;

    /**
     * 浏览器类型
     */

    private String browserType;
    /**
     * 平台类型
     */

    private String platformType;

    /**
     * 请求ID
     */
    private String requestId;
    /**
     * memberAddressId
     */
    private String memberAddrId;

    private String parentOrderId;

    /**
     * 充值中心订单充值类型代码
     */
    private String rechargeTypeCode;

    /**
     * 积分兑换现金比值
     */
    private BigDecimal scoreExchangeMoneyRatio;

    /**
     * 订单积分抵扣金额限比
     */
    private BigDecimal orderUseScoreRatio;

    /**
     * 订单类型枚举
     */
    private String orderType;

    private String rechargePhone;

    public static final String IPAD = "ipad";
    public static final String MOBILE = "mobile";
    public static final String PC = "pc";

    /**
     * 返回总商品数量(一个商品购买多件仍视为一个商品)
     *
     * @return int 商品数量合计
     */
    public int getSumGoodsCount() {
        return this.orderItems.size();
    }

    /**
     * 返回购买商品件数合计（计算各商品的购买件数）
     *
     * @return int 商品数量合计
     */
    public int getSumGoodsBuyCount() {
        int sumGoodsCount = 0;
        for(TempOrderItemVo oi : this.orderItems) {
            sumGoodsCount += oi.getCount();
        }

        return sumGoodsCount;
    }

    /**
     * 设置运费后，同步更新订单支付金额
     * @param sumShippingFee
     */
    public void setSumShippingFee(BigDecimal sumShippingFee) {
        this.sumShippingFee = sumShippingFee;
        if(sumShippingFee != null) {
            this.needPayPrice = sumShippingFee.add(this.sumPrice);
        }
    }

    /**
     * 重算合计金额
     */
    public void recalatePrices() {
        this.sumCostPrice = this.orderItems.stream()
                .map(TempOrderItemVo::getSumCostPrice)
                .reduce(BigDecimal.valueOf(0), BigDecimal::add);
        this.sumPrice = this.orderItems.stream()
                .map(TempOrderItemVo::getSumSalePrice)
                .reduce(BigDecimal.valueOf(0), BigDecimal::add);
        this.sumMarketPrice = this.orderItems.stream()
                .map(TempOrderItemVo::getSumMarketPrice)
                .reduce(BigDecimal.valueOf(0), BigDecimal::add);

        this.sumOrginalPrice = this.sumPrice;

        this.needPayPrice = this.sumPrice.add(this.sumShippingFee == null ? new BigDecimal(0) : this.sumShippingFee);
    }

//TODO: 以下设计不符合规范，VO类不应引入Request等带有状态的业务
//    /**
//     * 设置产品购买的渠道
//     * 如通过什么平台，什么浏览器等
//     * @param request
//     */
//    public void setBuyType(HttpServletRequest request) {
//        // \b 是单词边界(连着的两个(字母字符 与 非字母字符) 之间的逻辑上的间隔),
//        // 字符串在编译时会被转码一次,所以是 "\\b"
//        // \B 是单词内部逻辑间隔(连着的两个字母字符之间的逻辑上的间隔)
//        String phoneReg = "\\b(ip(hone|od)|android|opera m(ob|in)i" + "|windows (phone|ce)|blackberry" + "|s(ymbian|eries60|amsung)|p(laybook|alm|rofile/midp" + "|laystation portable)|nokia|fennec|htc[-_]" + "|mobile|up.browser|[1-4][0-9]{2}x[1-4][0-9]{2})\\b";
//        String tableReg = "\\b(ipad|tablet|(Nexus 7)|up.browser" + "|[1-4][0-9]{2}x[1-4][0-9]{2})\\b";
//
//        // 移动设备正则匹配：手机端、平板
//        Pattern phonePat = Pattern.compile(phoneReg, Pattern.CASE_INSENSITIVE);
//        Pattern tablePat = Pattern.compile(tableReg, Pattern.CASE_INSENSITIVE);
//
//        String userAgent = request.getHeader("USER-AGENT").toLowerCase();
//        if (null == userAgent) {
//            userAgent = "";
//        }
//        UserAgent agen = UserAgentUtil.getUserAgent(userAgent);
//
//        setBrowserType(agen.getBrowserType());
//
//        setPlatformType(agen.getPlatformType());
//
//        setHeadMessage(userAgent);
//
//        // 匹配
//        Matcher matcherPhone = phonePat.matcher(userAgent);
//        Matcher matcherTable = tablePat.matcher(userAgent);
//        if (matcherTable.find()) {
//            setBuyType(IPAD);
//        } else if (matcherPhone.find()) {
//            setBuyType(MOBILE);
//        } else {
//            setBuyType(PC);
//        }
//    }

}
