package order.vo.query;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author Liang Wenxu
 * @since 2018/7/10
 */
@Data
public class BaseQuery implements Serializable {
    /**
     * 创建日期开始
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    private Date dateCreatedLower;

    /**
     * 创建日期结束
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    private Date dateCreatedHigher;

    /**
     * 最后更新日期开始
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    private Date lastUpdatedLower;

    /**
     * 最后更新日期结束
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    private Date lastUpdatedHigher;


    private Boolean isDelete;

    /**
     * 删除日期开始
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    private Date deleteDateLower;

    /**
     * 删除日期结束
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    private Date deleteDateHigher;

}
