package order.vo.query;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import order.vo.OrderItemVo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
public class OrderDetailQueryVo implements Serializable {

    /**
     * 订单NO
     */
    private BigDecimal totalPrice;
    /**
     * 订单ID
     */
    private String orderId;
    /**
     * 订单NO
     */
    private String orderNo;
    /**
     * 订单所在的店铺的名字
     */
    private String storeName;
    /**
     * 下单时间
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date createdTime;
    /**
     * 订单金额
     */
    private BigDecimal sumCostPrice;
    /**
     * 收件地址
     */
    private String addressName;
    /**
     * 收件人
     */
    private String memberName;
    /**
     * 收件人电话
     */
    private String memberTel;

    /**
     * 子订单项
     */
    private List<OrderItemVo> children;

    /**
     * suborder订单状态( 未确定状态之前的订单状态，此时订单为被拆单)
     */
    private String singleSubOrderStatus;

    /**
     * subOrderItemWithSubOrderNo
     */
    private List<SubOrderItemWithSubOrderNo> subOrderItemWithSubOrderNo;

}