package order.vo.query;

import lombok.Data;

import java.io.Serializable;

/**
 * 订单处理模型适配配置查询条件
 * @author Liang Wenxu
 * @since 2018/7/10
 */
@Data
public class OrderTemplateAdapterConfigQuery extends BaseQuery implements Serializable {
    private static final long serialVersionUID = -3991135429890069268L;

    private String id;

    /**
     * 订单模式，1|2 (常规订单|批量订单)
     */
    public String orderMode;

    /**
     * 商品类型，如一次购买多个类型商品，实际要分别调用其对应的Template
     */
    public String goodsType;

    /**
     * 渠道代码
     */
    public String orgCode;

    /**
     * 订单处理模板类名（全称，包括包名）
     */
    public String templateClass;

    /**
     * 订单处理模板名（用作处理模板类的BeanName）
     */
    public String templateName;

    /**
     * 是否启用
     */
    public Boolean enabled;
}
