package order.vo.query;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class SubOrderItemQueryVo implements Serializable {

    public static final Integer TYPE_GENERAL = 0;//普通
    public static final Integer TYPE_ATTACHMENT = 1;//附件
    public static final Integer TYPE_GIFT = 2;//赠品

    protected String id;

    /**
     * 商品ID
     */
    private String goodsId;

    /**
     * 数量
     */
    private Integer count;

    /**
     * type为0普通、1附件、2赠品
     */
    private Integer type;

    /**
     * 商品的价格
     */
    private BigDecimal price;

    /**
     * 商品的名称
     */
    private String name;

    /**
     * 商品的税额
     */
    private BigDecimal taxPrice;

    /**
     * 商品的编码
     */
    private String skuId;

    /**
     * 商品价格-税额
     */
    private BigDecimal nakedPrice;


    /**
     * 商品图片path
     */
    private String picturePath;



}
