package order.vo.response;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author Liang Wenxu
 * @since 2018/7/25
 */
@Data
public class OrderItemPrice implements Serializable {
    /**
     * 原始售价
     */
    private BigDecimal orginalSumPrice;

    /**
     * 总销售价格
     */
    private BigDecimal sumSalesPrice;

    /**
     * 总成本价
     */
    private BigDecimal sumCostPrice;

    /**
     * 总市场价
     */
    private BigDecimal sumMarketPrice;

    /**
     * 销售价
     */
    private BigDecimal salesPrice;

    /**
     * 成本价
     */
    private BigDecimal costPrice;

    /**
     * 市场价
     */
    private BigDecimal marketPrice;

    /**
     * 数量
     */
    private Integer count;

    /**
     * 商品ID
     */
    private String fashionId;


    public OrderItemPrice(Integer count, String fashionId) {
        this.count = count;
        this.fashionId = fashionId;
    }
}
