package order.vo.response;

import lombok.Data;

import java.io.Serializable;

/**
 * @author Liang Wenxu
 * @since 2018/7/25
 */
@Data
public class OrderItemStock implements Serializable {
    public static final String STOCK_FLAG_NO_STOCK = "0"; // 无货
    public static final String STOCK_FLAG_HAS_STOCK = "1"; // 有货
    public static final String STOCK_FLAG_PRE_ORDER = "2"; // 预定

    /**
     * 不可销售理由代码{@value}: 产品下架（电商平台运维下架）
     */
    public static final String NOTSALE_REASON_PRODUCT_DOWN = "1";

    /**
     * 不可销售理由代码{@value}: 机构无权购买该商品
     */
    public static final String NOTSALE_REASON_NOCOMPANY_PREM = "2";
    /**
     * 不可销售理由代码{@value}: 供应商下架
     */
    public static final String NOTSALE_REASON_SUPPLIER_DOWN = "3";

    private String fashionId; // 规格ID

    private String sku; // 第三方平台对应的产品代码

    Boolean onSale; // 是否可销售

    Long stockCount; // 库存数量，如京东等无库存返回的，则为-1

    Boolean isAreaRestrict; // 是否限制销售地区

    String stockFlag; // 是否有货 0-- 无货，1--有货，2--预定（延后发货）

    /**
     * 限售原因，当onSale为false时可能有值
     * 取值见NOTSALE_REASON_开头常量
     */
    private String notsaleReason;
}
