package order.vo.response;

import lombok.Data;
import utils.Lang;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 订单金额
 * @author Liang Wenxu
 * @since 2018/7/24
 */
@Data
public class OrderPrice implements Serializable {
    /**
     * 订单号
     */
    private String orderNo;

    /**
     * 原始售价
     */
    private BigDecimal orginalSumPrice;

    /**
     * 商品销售总价（不含运费）
     */
    private BigDecimal salesPrice;

    /**
     * 订单总价（含运费）
     */
    private BigDecimal orderPrice;

    /**
     * 总运费
     */
    private BigDecimal freight;

    /**
     * 总成本价
     */
    private BigDecimal costPrice;

    /**
     * 总市场价
     */
    private BigDecimal marketPrice;

    /**
     * 子订单的金额
     */
    List<OrderPrice> subOrderPrices;

    /**
     * 订单商品的价格
     */
    List<OrderItemPrice> orderItemPrices;

    /**
     * 执行订单金额合计的重算
     */
    public void recalSumPrices() {
        if(orderItemPrices != null && orderItemPrices.size() > 0) {
            this.salesPrice = orderItemPrices.stream()
                    .map(OrderItemPrice::getSumSalesPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            orginalSumPrice = this.salesPrice;
            this.costPrice = orderItemPrices.stream()
                    .map(OrderItemPrice::getSumCostPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            this.marketPrice = orderItemPrices.stream()
                    .map(OrderItemPrice::getSumMarketPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            this.orderPrice = this.salesPrice.add(freight == null ? BigDecimal.ZERO : freight);
        }
    }

    /**
     * 在子订单价格中，按订单号查找子单价格，找不到就返回null
     * @param orderNo 临时订单号
     * @return
     */
    public OrderPrice findChildFirst(String orderNo) {
        OrderPrice r = null;
        if(Lang.isEmpty(this.orderNo)) {
            return null;
        }
        if(this.orderNo.equals(orderNo)) {
            r = this;
        } else if(this.getSubOrderPrices() != null) {
            for(OrderPrice c : this.getSubOrderPrices()) {
                r = c.findChildFirst(orderNo);
                if(r != null) {
                    break;
                }
            }
        }


        return r;
    }
}
