/*
 * Decompiled with CFR 0.152.
 */
package order.vo.response;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import order.vo.response.OrderItemPrice;
import utils.Lang;

public class OrderPrice
implements Serializable {
    private String orderNo;
    private BigDecimal orginalSumPrice;
    private BigDecimal salesPrice;
    private BigDecimal orderPrice;
    private BigDecimal freight;
    private BigDecimal costPrice;
    private BigDecimal marketPrice;
    List<OrderPrice> subOrderPrices;
    List<OrderItemPrice> orderItemPrices;

    public void recalSumPrices() {
        if (this.orderItemPrices != null && this.orderItemPrices.size() > 0) {
            this.orginalSumPrice = this.salesPrice = this.orderItemPrices.stream().map(OrderItemPrice::getSumSalesPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            this.costPrice = this.orderItemPrices.stream().map(OrderItemPrice::getSumCostPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            this.marketPrice = this.orderItemPrices.stream().map(OrderItemPrice::getSumMarketPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            this.orderPrice = this.salesPrice.add(this.freight == null ? BigDecimal.ZERO : this.freight);
        }
    }

    public OrderPrice findChildFirst(String orderNo) {
        OrderPrice r;
        block3: {
            OrderPrice c;
            block2: {
                r = null;
                if (Lang.isEmpty((Object)this.orderNo)) {
                    return null;
                }
                if (!this.orderNo.equals(orderNo)) break block2;
                r = this;
                break block3;
            }
            if (this.getSubOrderPrices() == null) break block3;
            Iterator<OrderPrice> iterator = this.getSubOrderPrices().iterator();
            while (iterator.hasNext() && (r = (c = iterator.next()).findChildFirst(orderNo)) == null) {
            }
        }
        return r;
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public BigDecimal getOrginalSumPrice() {
        return this.orginalSumPrice;
    }

    public BigDecimal getSalesPrice() {
        return this.salesPrice;
    }

    public BigDecimal getOrderPrice() {
        return this.orderPrice;
    }

    public BigDecimal getFreight() {
        return this.freight;
    }

    public BigDecimal getCostPrice() {
        return this.costPrice;
    }

    public BigDecimal getMarketPrice() {
        return this.marketPrice;
    }

    public List<OrderPrice> getSubOrderPrices() {
        return this.subOrderPrices;
    }

    public List<OrderItemPrice> getOrderItemPrices() {
        return this.orderItemPrices;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public void setOrginalSumPrice(BigDecimal orginalSumPrice) {
        this.orginalSumPrice = orginalSumPrice;
    }

    public void setSalesPrice(BigDecimal salesPrice) {
        this.salesPrice = salesPrice;
    }

    public void setOrderPrice(BigDecimal orderPrice) {
        this.orderPrice = orderPrice;
    }

    public void setFreight(BigDecimal freight) {
        this.freight = freight;
    }

    public void setCostPrice(BigDecimal costPrice) {
        this.costPrice = costPrice;
    }

    public void setMarketPrice(BigDecimal marketPrice) {
        this.marketPrice = marketPrice;
    }

    public void setSubOrderPrices(List<OrderPrice> subOrderPrices) {
        this.subOrderPrices = subOrderPrices;
    }

    public void setOrderItemPrices(List<OrderItemPrice> orderItemPrices) {
        this.orderItemPrices = orderItemPrices;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderPrice)) {
            return false;
        }
        OrderPrice other = (OrderPrice)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$orderNo = this.getOrderNo();
        String other$orderNo = other.getOrderNo();
        if (this$orderNo == null ? other$orderNo != null : !this$orderNo.equals(other$orderNo)) {
            return false;
        }
        BigDecimal this$orginalSumPrice = this.getOrginalSumPrice();
        BigDecimal other$orginalSumPrice = other.getOrginalSumPrice();
        if (this$orginalSumPrice == null ? other$orginalSumPrice != null : !((Object)this$orginalSumPrice).equals(other$orginalSumPrice)) {
            return false;
        }
        BigDecimal this$salesPrice = this.getSalesPrice();
        BigDecimal other$salesPrice = other.getSalesPrice();
        if (this$salesPrice == null ? other$salesPrice != null : !((Object)this$salesPrice).equals(other$salesPrice)) {
            return false;
        }
        BigDecimal this$orderPrice = this.getOrderPrice();
        BigDecimal other$orderPrice = other.getOrderPrice();
        if (this$orderPrice == null ? other$orderPrice != null : !((Object)this$orderPrice).equals(other$orderPrice)) {
            return false;
        }
        BigDecimal this$freight = this.getFreight();
        BigDecimal other$freight = other.getFreight();
        if (this$freight == null ? other$freight != null : !((Object)this$freight).equals(other$freight)) {
            return false;
        }
        BigDecimal this$costPrice = this.getCostPrice();
        BigDecimal other$costPrice = other.getCostPrice();
        if (this$costPrice == null ? other$costPrice != null : !((Object)this$costPrice).equals(other$costPrice)) {
            return false;
        }
        BigDecimal this$marketPrice = this.getMarketPrice();
        BigDecimal other$marketPrice = other.getMarketPrice();
        if (this$marketPrice == null ? other$marketPrice != null : !((Object)this$marketPrice).equals(other$marketPrice)) {
            return false;
        }
        List<OrderPrice> this$subOrderPrices = this.getSubOrderPrices();
        List<OrderPrice> other$subOrderPrices = other.getSubOrderPrices();
        if (this$subOrderPrices == null ? other$subOrderPrices != null : !((Object)this$subOrderPrices).equals(other$subOrderPrices)) {
            return false;
        }
        List<OrderItemPrice> this$orderItemPrices = this.getOrderItemPrices();
        List<OrderItemPrice> other$orderItemPrices = other.getOrderItemPrices();
        return !(this$orderItemPrices == null ? other$orderItemPrices != null : !((Object)this$orderItemPrices).equals(other$orderItemPrices));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrderPrice;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $orderNo = this.getOrderNo();
        result = result * 59 + ($orderNo == null ? 43 : $orderNo.hashCode());
        BigDecimal $orginalSumPrice = this.getOrginalSumPrice();
        result = result * 59 + ($orginalSumPrice == null ? 43 : ((Object)$orginalSumPrice).hashCode());
        BigDecimal $salesPrice = this.getSalesPrice();
        result = result * 59 + ($salesPrice == null ? 43 : ((Object)$salesPrice).hashCode());
        BigDecimal $orderPrice = this.getOrderPrice();
        result = result * 59 + ($orderPrice == null ? 43 : ((Object)$orderPrice).hashCode());
        BigDecimal $freight = this.getFreight();
        result = result * 59 + ($freight == null ? 43 : ((Object)$freight).hashCode());
        BigDecimal $costPrice = this.getCostPrice();
        result = result * 59 + ($costPrice == null ? 43 : ((Object)$costPrice).hashCode());
        BigDecimal $marketPrice = this.getMarketPrice();
        result = result * 59 + ($marketPrice == null ? 43 : ((Object)$marketPrice).hashCode());
        List<OrderPrice> $subOrderPrices = this.getSubOrderPrices();
        result = result * 59 + ($subOrderPrices == null ? 43 : ((Object)$subOrderPrices).hashCode());
        List<OrderItemPrice> $orderItemPrices = this.getOrderItemPrices();
        result = result * 59 + ($orderItemPrices == null ? 43 : ((Object)$orderItemPrices).hashCode());
        return result;
    }

    public String toString() {
        return "OrderPrice(orderNo=" + this.getOrderNo() + ", orginalSumPrice=" + this.getOrginalSumPrice() + ", salesPrice=" + this.getSalesPrice() + ", orderPrice=" + this.getOrderPrice() + ", freight=" + this.getFreight() + ", costPrice=" + this.getCostPrice() + ", marketPrice=" + this.getMarketPrice() + ", subOrderPrices=" + this.getSubOrderPrices() + ", orderItemPrices=" + this.getOrderItemPrices() + ")";
    }
}

