package order.model.po;

import order.model.po.base.BaseDomain;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import java.io.Serializable;

/**
 * @author wangtao.
 * @version 0.9 附件表 2018-3-7 14:31:21.
 */

@Entity
public class MallAttachment extends BaseDomain implements Serializable {

    /**
     * 主键.
     */
    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    private String id;

    /**
     * 渠道代码.
     */
    private String organizationCode;

    /*
     * 附件名称.
     */
    private String attachmentName;

    /**
     * 业务附件关联.
     */
    private String attachmentCorrelation;

    /**
     * 业务代码.
     */
    private String businessCode;

    /**
     * 业务描述.
     */
    private String businessDescription;


    /**
     * 附件访问地址.
     */
    private String url;

    /**
     * 附件物理地址.
     */
    private String path;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOrganizationCode() {
        return organizationCode;
    }

    public void setOrganizationCode(String organizationCode) {
        this.organizationCode = organizationCode;
    }

    public String getAttachmentName() {
        return attachmentName;
    }

    public void setAttachmentName(String attachmentName) {
        this.attachmentName = attachmentName;
    }

    public String getAttachmentCorrelation() {
        return attachmentCorrelation;
    }

    public void setAttachmentCorrelation(String attachmentCorrelation) {
        this.attachmentCorrelation = attachmentCorrelation;
    }

    public String getBusinessCode() {
        return businessCode;
    }

    public void setBusinessCode(String businessCode) {
        this.businessCode = businessCode;
    }

    public String getBusinessDescription() {
        return businessDescription;
    }

    public void setBusinessDescription(String businessDescription) {
        this.businessDescription = businessDescription;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}
