package order.model.po;

import order.model.po.base.BaseDomain;
import org.hibernate.annotations.GenericGenerator;
import org.junit.Test;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author junyang.dong
 * @version v1.0
 * @date 2018/5/9
 * 商城父订单表
 */
@Entity
@Table
public class MallParentOrder extends BaseDomain implements Serializable {

    /**
     * 主键.
     */
    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    private String id;

    /**
     * 父订单号
     */
    private String parentOrderNo;

    /**
     * 父订单状态
     */
    private String status;

    /**
     * 运费
     */
    private BigDecimal freight;

    /**
     * 商品金额
     */
    private BigDecimal goodsPrice;

    /**
     * 订单用途
     */
    private String orderUse;

    /**
     * 订单总金额
     */
    private BigDecimal totalMoney;

    /**
     * 下单机构
     */
    private String companyName;

    /**
     * 订单类型
     */
    private String orderType;

    /**
     * 支付方式
     */
    private String payType;

    /**
     * 采购编号
     */
    private String purchaseNo;

    /**
     * 供应商名称
     */
    private String supplierName;
    /**
     * 会员id
     */
    private String memberId;
    /**
     * 会员名称
     */
    private String memberName;
    /**
     * 备注
     */
    private String remark;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getParentOrderNo() {
        return parentOrderNo;
    }

    public void setParentOrderNo(String parentOrderNo) {
        this.parentOrderNo = parentOrderNo;
    }

    public String getMemberName() {
        return memberName;
    }

    public void setMemberName(String memberName) {
        this.memberName = memberName;
    }

    public String getMemberId() {
        return memberId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public BigDecimal getFreight() {
        return freight;
    }

    public void setFreight(BigDecimal freight) {
        this.freight = freight;
    }

    public BigDecimal getGoodsPrice() {
        return goodsPrice;
    }

    public void setGoodsPrice(BigDecimal goodsPrice) {
        this.goodsPrice = goodsPrice;
    }

    public String getOrderUse() {
        return orderUse;
    }

    public void setOrderUse(String orderUse) {
        this.orderUse = orderUse;
    }

    public BigDecimal getTotalMoney() {
        return totalMoney;
    }

    public void setTotalMoney(BigDecimal totalMoney) {
        this.totalMoney = totalMoney;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getPayType() {
        return payType;
    }

    public void setPayType(String payType) {
        this.payType = payType;
    }

    public String getPurchaseNo() {
        return purchaseNo;
    }

    public void setPurchaseNo(String purchaseNo) {
        this.purchaseNo = purchaseNo;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
