package order.model.po;

import order.model.po.base.BaseDomain;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;

/**
 * @author junyang.dong
 * @version v1.0
 * @date 2018/5/9
 * 商城临时订单商品表
 */
@Entity
public class MallTempGoods extends BaseDomain implements Serializable {

    /**
     * 主键.
     */
    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    private String id;

    /**
     * 商城临时订单ID
     */
    @ManyToOne
    @JoinColumn(name = "MALL_TEMP_ORDER_ID", foreignKey = @ForeignKey(name = "CKT_MALL_TEMP_GOODS"))
    private MallTempOrder mallTempOrder;

    /**
     * sku
     */
    private String sku;

    /**
     * 数量
     */
    private Integer num;

    /**
     * productFashionId
     */
    private String productFashionId;

    /**
     * goodsId
     */
    private String goodsId;

    /**
     * 店铺id
     */
    private String storeId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public MallTempOrder getMallTempOrder() {
        return mallTempOrder;
    }

    public void setMallTempOrder(MallTempOrder mallTempOrder) {
        this.mallTempOrder = mallTempOrder;
    }

    public String getSku() {
        return sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public Integer getNum() {
        return num;
    }

    public void setNum(Integer num) {
        this.num = num;
    }

    public String getProductFashionId() {
        return productFashionId;
    }

    public void setProductFashionId(String productFashionId) {
        this.productFashionId = productFashionId;
    }

    public String getGoodsId() {
        return goodsId;
    }

    public void setGoodsId(String goodsId) {
        this.goodsId = goodsId;
    }

    public String getStoreId() {
        return storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }
}
