package order.model.po;

import order.model.po.base.BaseDomain;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.List;

/**
 * @author junyang.dong
 * @version v1.0
 * @date 2018/5/9
 * 商城临时订单表
 */
@Entity
public class MallTempOrder extends BaseDomain implements Serializable {
    /**
     * 主键.
     */
    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    private String id;

    @OneToMany(fetch = FetchType.LAZY, cascade = CascadeType.ALL, mappedBy = "mallTempOrder")
    private List<MallTempGoods> mallTempGoods;

    /**
     * 渠道代码
     */
    private String organizationCode;

    /**
     * 会员id
     */
    private String memberId;

    /**
     * 会员地址表id
     */
    private String memberAddressId;

    /**
     * 会员地址详细
     */
    private String memberAddress;

    /**
     * 会员地址编号
     */
    private String memberAddressNo;

    /**
     * 发票类型
     */
    private String invoiceType;

    /**
     * 发票抬头
     */
    private String invoiceTitle;

    /**
     * 纳税人识别号
     */
    private String taxIdentification;

    /**
     * 开票机构
     */
    private String invoiceOrganization;

    /**
     * 发票收件人
     */
    private String consigneeName;

    /**
     * 发票收件人电话
     */
    private String consigneePhone;
    /**
     * 发票收件人省
     */
    private String consigneeProvinceCode;

    /**
     * 发票收件人市
     */
    private String consigneeCityCode;
    /**
     * 详细地址
     */
    private String addressDetail;

    /**
     * 发票会员地址表id
     */
    private String invoiceAddressId;

    /**
     * 发票会员地址表编号
     */
    private String invoiceAddressNo;

    /**
     * 发票地址详细
     */
    private String invoiceAddress;


    /**
     * 发票地址是否同收件地址
     */
    private Integer consigneeFlag;

    /**
     * 发票机构id
     */
    private String companyId;

    /**
     * 下单失败错误信息
     */
    private String errorInfo;

    /**
     * 是否勾选协议
     */
    //private Integer isCheckOffAgree;
    /**
     * 收件人省市码(便于查询该临时订单下商品价格)
     */
    private String provinceCode;
    private String cityCode;
    private String townCode;
    private String countryCode;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<MallTempGoods> getMallTempGoods() {
        return mallTempGoods;
    }

    public void setMallTempGoods(List<MallTempGoods> mallTempGoods) {
        this.mallTempGoods = mallTempGoods;
    }

    public String getOrganizationCode() {
        return organizationCode;
    }

    public void setOrganizationCode(String organizationCode) {
        this.organizationCode = organizationCode;
    }

    public String getMemberId() {
        return memberId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public String getMemberAddressId() {
        return memberAddressId;
    }

    public void setMemberAddressId(String memberAddressId) {
        this.memberAddressId = memberAddressId;
    }

    public String getMemberAddressNo() {
        return memberAddressNo;
    }

    public void setMemberAddressNo(String memberAddressNo) {
        this.memberAddressNo = memberAddressNo;
    }

    public String getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }

    public String getInvoiceTitle() {
        return invoiceTitle;
    }

    public void setInvoiceTitle(String invoiceTitle) {
        this.invoiceTitle = invoiceTitle;
    }

    public String getTaxIdentification() {
        return taxIdentification;
    }

    public void setTaxIdentification(String taxIdentification) {
        this.taxIdentification = taxIdentification;
    }

    public String getInvoiceOrganization() {
        return invoiceOrganization;
    }

    public void setInvoiceOrganization(String invoiceOrganization) {
        this.invoiceOrganization = invoiceOrganization;
    }

    public String getConsigneeName() {
        return consigneeName;
    }

    public void setConsigneeName(String consigneeName) {
        this.consigneeName = consigneeName;
    }

    public String getConsigneePhone() {
        return consigneePhone;
    }

    public void setConsigneePhone(String consigneePhone) {
        this.consigneePhone = consigneePhone;
    }

    public String getInvoiceAddressId() {
        return invoiceAddressId;
    }

    public void setInvoiceAddressId(String invoiceAddressId) {
        this.invoiceAddressId = invoiceAddressId;
    }

    public String getInvoiceAddressNo() {
        return invoiceAddressNo;
    }

    public void setInvoiceAddressNo(String invoiceAddressNo) {
        this.invoiceAddressNo = invoiceAddressNo;
    }

    public Integer getConsigneeFlag() {
        return consigneeFlag;
    }

    public void setConsigneeFlag(Integer consigneeFlag) {
        this.consigneeFlag = consigneeFlag;
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public String getConsigneeProvinceCode() {
        return consigneeProvinceCode;
    }

    public void setConsigneeProvinceCode(String consigneeProvinceCode) {
        this.consigneeProvinceCode = consigneeProvinceCode;
    }

    public String getConsigneeCityCode() {
        return consigneeCityCode;
    }

    public void setConsigneeCityCode(String consigneeCityCode) {
        this.consigneeCityCode = consigneeCityCode;
    }

    public String getAddressDetail() {
        return addressDetail;
    }

    public void setAddressDetail(String addressDetail) {
        this.addressDetail = addressDetail;
    }

    public String getErrorInfo() {
        return errorInfo;
    }

    public void setErrorInfo(String errorInfo) {
        this.errorInfo = errorInfo;
    }

    public String getMemberAddress() {
        return memberAddress;
    }

    public void setMemberAddress(String memberAddress) {
        this.memberAddress = memberAddress;
    }

    public String getInvoiceAddress() {
        return invoiceAddress;
    }

    public void setInvoiceAddress(String invoiceAddress) {
        this.invoiceAddress = invoiceAddress;
    }

    public String getProvinceCode() {
        return provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getTownCode() {
        return townCode;
    }

    public void setTownCode(String townCode) {
        this.townCode = townCode;
    }

    public String getCountryCode() {
        return countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }
}
