package order.model.po;

import order.model.po.base.BaseDomain;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import java.io.Serializable;

/**
 * @author junyang.dong
 * @version v1.0
 * @date 2018/5/10
 * 商城临时订单公用信息表
 */
@Entity
public class MallTempOrderInfo extends BaseDomain implements Serializable{
    /**
     * 主键.
     */
    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    private String id;
    /**
     * 会员id
     */
    private String memberId;
    /**
     * 支付方式
     */
    private String payMethod;
    /**
     * 订单用途
     */
    private String orderUsage;
    /**
     * 备注
     */
    private String remark;
    /**
     * 附件
     */
    private String attchments;

    /**
     * 是否勾选协议
     */
    private Integer isCheckOffAgree;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getMemberId() {
        return memberId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public String getPayMethod() {
        return payMethod;
    }

    public void setPayMethod(String payMethod) {
        this.payMethod = payMethod;
    }

    public String getOrderUsage() {
        return orderUsage;
    }

    public void setOrderUsage(String orderUsage) {
        this.orderUsage = orderUsage;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getAttchments() {
        return attchments;
    }

    public void setAttchments(String attchments) {
        this.attchments = attchments;
    }

    public Integer getIsCheckOffAgree() {
        return isCheckOffAgree;
    }

    public void setIsCheckOffAgree(Integer isCheckOffAgree) {
        this.isCheckOffAgree = isCheckOffAgree;
    }
}
