package order.model.po;

import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * Created by xiaoqian on 2016/9/28.
 */
@Entity
@Table(indexes = {
        @Index(name = "idx_order_item_product", columnList = "product_id"),
        @Index(name = "idx_order_item_goods", columnList = "goods_id"),
        @Index(name = "idx_order_item_fash", columnList = "product_fash_id")
})
public class OrderItem implements Serializable {
    /**
     * 产品类型{@value}: 商品
     */
    public static final String PRODUCT_TYPE_MERCHANDISE = "1";
    /**
     * 产品类型{@value}: 配件
     */
    public static final String PRODUCT_TYPE_FITTING = "2";
    /**
     * 产品类型{@value}: 赠品
     */
    public static final String PRODUCT_TYPE_GIFT = "3";

    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    @Column(length = 36)
    protected String id;

    @ManyToOne
    @JoinColumn(name = "order_id", foreignKey = @ForeignKey(name = "fk_o_item_order"))
    private OrderMain order;

    @Column(length = 36, name = "product_id")
    private String productId;
    @Column(length = 36, name = "goods_id")
    private String goodsId;

    private String productName;    //包括规格
    @Column(length = 36, name = "product_fash_id")
    private String productFashId;

    /**
     * 产品类型，详见Product中的PRODUCT_TYPE_开头
     */
    private String productType;

    /**
     * 产品图片（缩略图）
     */
    private String productPic;

    /**
     * 购买数量
     */
    private Integer count;

    private Integer returnCount;

    /**
     * 商品售价，对应最终的商品销售价格
     * 当存在主、配件组合时，此价格为主商品 + 配件的价格合计
     */
    @Column(scale = 2)
    private BigDecimal salePrice;

    /**
     * 原始商品售价，当存在主、配件组合时，此价格为主商品价格
     */
    @Column(scale = 2)
    private BigDecimal orginSalePrice;

    /**
     * 会员价
     */
    @Column(scale = 2)
    private BigDecimal memberPrice;

    /**
     * 商品成本价
     */
    @Column(scale = 2)
    private BigDecimal costPrice;

    /**
     * 商品最终售价
     */
    @Column(scale = 2)
    private BigDecimal finalPrice;

    /**
     * 秒杀价
     */
    @Column(scale = 2)
    private BigDecimal seckillPrice;

    /**
     * 产品价格
     */
    @Column(scale = 2)
    private BigDecimal productPrice;

    /**
     * 下单时商品销售价格浮动比例
     */
    @Column(scale = 2)
    private BigDecimal salePriceRate;

    private BigDecimal historyCostScore;
    /**
     * 是否已评价
     */
    private Boolean isDiscuss = false;
    //是否是活动商品
    private String activityId;
    /**
     * 是否已退货
     */
    private Boolean isRefund = false;

    /**
     * 预计送达时间（苏宁、）
     */
    private String arriveDate;

    /**
     * 供应商货物编码，如京东、苏宁的skuId
     */
    private String sku;

    /**
     * 第三方订单行号（苏宁、）
     */
    private String orderLineNumId;

    /**
     * 第三方套餐商品编号
     */
    private String packageNumber;

    /**
     * 下单时的第三方售价
     */
    private BigDecimal trdSalePrice;

    /**
     * 增加业务码 2018-5-30(竞价优化需求这里用作于需求编号，后期也可适用其他业务码)
     */
    private String businessCode;

    /**
     * 比价商品信息
     */
    @OneToMany(cascade = CascadeType.ALL, fetch = FetchType.EAGER, mappedBy = "orderItem")
    private List<OrderParity> orderParities;

    @OneToMany(cascade = CascadeType.ALL, mappedBy = "parent")
    private List<OrderItem> children;

    @ManyToOne
    @JoinColumn(name = "parent_id")
    private OrderItem parent;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        OrderItem orderItem = (OrderItem) o;

        return !(id != null ? !id.equals(orderItem.id) : orderItem.id != null);

    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }

    public BigDecimal getHistoryCostScore() {
        return historyCostScore;
    }

    public void setHistoryCostScore(BigDecimal historyCostScore) {
        this.historyCostScore = historyCostScore;
    }

    public Boolean getDiscuss() {
        return isDiscuss;
    }

    public String getActivityId() {
        return activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public Integer getReturnCount() {
        return returnCount;
    }

    public void setReturnCount(Integer returnCount) {
        this.returnCount = returnCount;
    }

    public String getGoodsId() {
        return goodsId;
    }

    public void setGoodsId(String goodsId) {
        this.goodsId = goodsId;
    }

    public BigDecimal getProductPrice() {
        return productPrice;
    }

    public void setProductPrice(BigDecimal productPrice) {
        this.productPrice = productPrice;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public OrderMain getOrder() {
        return order;
    }

    public void setOrder(OrderMain order) {
        this.order = order;
    }

    public String getProductId() {
        return productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductFashId() {
        return productFashId;
    }

    public void setProductFashId(String productFashId) {
        this.productFashId = productFashId;
    }

    public Integer getCount() {
        return count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public BigDecimal getSalePrice() {
        return salePrice;
    }

    public void setSalePrice(BigDecimal salePrice) {
        this.salePrice = salePrice;
    }

    public BigDecimal getMemberPrice() {
        return memberPrice;
    }

    public void setMemberPrice(BigDecimal memberPrice) {
        this.memberPrice = memberPrice;
    }

    public BigDecimal getCostPrice() {
        return costPrice;
    }

    public void setCostPrice(BigDecimal costPrice) {
        this.costPrice = costPrice;
    }

    public BigDecimal getFinalPrice() {
        return finalPrice;
    }

    public void setFinalPrice(BigDecimal finalPrice) {
        this.finalPrice = finalPrice;
    }

    public BigDecimal getSeckillPrice() {
        return seckillPrice;
    }

    public void setSeckillPrice(BigDecimal seckillPrice) {
        this.seckillPrice = seckillPrice;
    }

    public Boolean isDiscuss() {
        return isDiscuss;
    }

    public void setDiscuss(Boolean discuss) {
        isDiscuss = discuss;
    }

    public Boolean getIsDiscuss() {
        return isDiscuss;
    }

    public void setIsDiscuss(Boolean discuss) {
        isDiscuss = discuss;
    }

    public String getArriveDate() {
        return arriveDate;
    }

    public void setArriveDate(String arriveDate) {
        this.arriveDate = arriveDate;
    }

    public String getOrderLineNumId() {
        return orderLineNumId;
    }

    public void setOrderLineNumId(String orderLineNumId) {
        this.orderLineNumId = orderLineNumId;
    }

    public String getPackageNumber() {
        return packageNumber;
    }

    public void setPackageNumber(String packageNumber) {
        this.packageNumber = packageNumber;
    }

    public Boolean getIsRefund() {
        return isRefund;
    }

    public void setIsRefund(Boolean refund) {
        isRefund = refund;
    }

    public Boolean getRefund() {
        return isRefund;
    }

    public void setRefund(Boolean refund) {
        isRefund = refund;
    }

    public BigDecimal getSalePriceRate() {
        return salePriceRate;
    }

    public void setSalePriceRate(BigDecimal salePriceRate) {
        this.salePriceRate = salePriceRate;
    }

    public String getBusinessCode() {
        return businessCode;
    }

    public void setBusinessCode(String businessCode) {
        this.businessCode = businessCode;
    }

    /**
     * 获取 下单时的第三方售价
     */
    public BigDecimal getTrdSalePrice() {
        return this.trdSalePrice;
    }

    /**
     * 设置 下单时的第三方售价
     */
    public void setTrdSalePrice(BigDecimal trdSalePrice) {
        this.trdSalePrice = trdSalePrice;
    }


    /**
     * 获取 供应商货物编码，如京东、苏宁的skuId
     */
    public String getSku() {
        return this.sku;
    }

    /**
     * 设置 供应商货物编码，如京东、苏宁的skuId
     */
    public void setSku(String sku) {
        this.sku = sku;
    }


    /**
     * 获取 产品类型
     */
    public String getProductType() {
        return this.productType;
    }

    /**
     * 设置 产品类型
     */
    public void setProductType(String productType) {
        this.productType = productType;
    }

    /**
     * 获取 产品图片
     */
    public String getProductPic() {
        return this.productPic;
    }

    /**
     * 设置 产品图片
     */
    public void setProductPic(String productPic) {
        this.productPic = productPic;
    }

    /**
     * 获取 比价商品信息
     */
    public List<OrderParity> getOrderParities() {
        return this.orderParities;
    }

    /**
     * 设置 比价商品信息
     */
    public void setOrderParities(List<OrderParity> orderParities) {
        this.orderParities = orderParities;
    }

    public List<OrderItem> getChildren() {
        return children;
    }

    public void setChildren(List<OrderItem> children) {
        this.children = children;
    }

    public OrderItem getParent() {
        return parent;
    }

    public void setParent(OrderItem parent) {
        this.parent = parent;
    }

    public BigDecimal getOrginSalePrice() {
        return orginSalePrice;
    }

    public void setOrginSalePrice(BigDecimal orginSalePrice) {
        this.orginSalePrice = orginSalePrice;
    }
}
