package order.model.po;

import order.model.po.base.BaseDomain;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;

/**
 * 产品关联关系配置表
 *
 * 配置商品与商品间的关联关系
 * 包括配件、赠品与主商品关联
 * 捆绑销售商品间的关联
 * @author Liang Wenxu
 * @since 2018-01-05
 */
@Entity
@Table(name = "ORDER_ITEM_RELATIONS")
public class OrderItemRelations extends BaseDomain {
    private static final long serialVersionUID = -2200654978534041731L;

    /**
     * 产品间关联关系{@value}: 从属关系（用于赠品、配件与主商品）
     */
    public static String PROD_RELATE_TYPE_SUBORDINATE = "1";

    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    @Column(length = 36)
    private String id;
    private String type;//	关联类型
    @Column(length = 36)
    private String childId;//从属Item ID
    @Column(length = 36)
    private String parentId;//主产品Item ID

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getChildId() {
        return childId;
    }

    public void setChildId(String childId) {
        this.childId = childId;
    }

    public String getParentId() {
        return parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }
}
