package order.model.po;

import order.model.po.base.BaseDomain;
import com.alibaba.fastjson.annotation.JSONField;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Type;
import utils.Lang;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 订单主表实体类
 * Created by xiaoqian on 2016/9/28.
 */
@Entity
@Table(
        uniqueConstraints = {
                @UniqueConstraint(name = "uk_third_order_no_store", columnNames = {"third_order_no", "store_id", "is_delete"}),
                @UniqueConstraint(name = "uk_request_id_store", columnNames = {"request_id", "store_id", "is_delete"})
        }, indexes = {
        @Index(name = "idx_order_payment_id", columnList = "payment_id"),
        @Index(name = "idx_order_member_id", columnList = "member_id"),
        @Index(name = "idx_order_store_id", columnList = "store_id"),
        @Index(name = "idx_third_order_no", columnList = "third_order_no"),
        @Index(name = "idx_order_request_id", columnList = "request_id"),
        @Index(name = "idx_order_order_no", columnList = "order_no", unique = true),
        @Index(name = "idx_order_company_id", columnList = "company_id", unique = false)
})
public class OrderMain extends BaseDomain implements Serializable {

    public final static String ORDER_NO_PREFIX = ""; // 生成订单号前缀
    public final static int ORDER_NO_SIZE = 10; // 生成订单号长度（总长度 = ORDER_NO_PREFIX长度 + 4（年份） + ORDER_NO_SIZE）
    public final static String ORDER_NO_KEY = "ORDER_NO"; // 生成订单号序列关键字

    /**
     * 订单支付方式：{@value}纯钱支付
     */
    public final static String PAY_METHOD_MONEY = "MONEY"; // 用钱支付
    /**
     * 订单支付方式：{@value}纯积分支付
     */
    public final static String PAY_METHOD_SCORE = "SCORE"; // 用积分支付
    /**
     * 订单支付方式：{@value}钱和积分组合
     */
    public final static String PAY_METHOD_SCORE_MONEY = "SCORE_MONEY"; // 钱和积分组合
    /**
     * 订单支付方式：{@value}机构的积分不足
     */
    public final static String PAY_METHOD_ORG_NO_ENOUGH_SCORE = "ORG_NO_ENOUGH_SCORE"; //


    /**
     * 订单状态
     */
    public final static Map<String, String> order_status = new HashMap<>();
    /**
     * 订单状态：{@value}新建
     */
    public final static String order_status_neworder = "0";
    /**
     * 订单状态：{@value}待付款
     */
    public final static String order_status_obligation = "1";
    /**
     * 订单状态：{@value}待收货（集采及城通）
     */
    public final static String order_status_ounfilled = "2";
    /**
     * 订单状态：{@value}待收货（太平积分）
     */
    public final static String order_status_notdeliver = "3";
    /**
     * 订单状态：{@value}已收货
     */
    public final static String order_status_evaluate = "4";
    /**
     * 订单状态：{@value}已完成
     */
    public final static String order_status_finish = "5";
    /**
     * 订单状态：{@value}已取消(客户取消)
     */
    public final static String order_status_cancel = "6";
    /**
     * 订单状态：{@value}拒收
     */
    public final static String order_status_refuse = "7";
    /**
     * 订单状态：{@value}已取消（系统自动取消）
     */
    public final static String order_status_outoftime_cancel = "8";
    /**
     * 订单状态：{@value}错误
     */
    public final static String order_status_error = "9";
    /**
     * 订单状态：{@value}审核中
     */
    public final static String order_status_inCheck = "10";
    /**
     * 订单状态：{@value}审核不通过
     */
    public final static String order_status_noPass = "11";
    /**
     * 订单状态：{@value}提现失败
     */
    public final static String order_status_tixinFail = "12";
    /**
     * 订单状态：{@value}维护中
     */
    public final static String order_status_Weihu = "13";

    /**
     * 订单状态：{@value}退货
     */
    public final static String order_status_return = "14";

    /**
     * 订单状态：{@value}待确认（供应商自行发货，需供应商确认后才发货）
     */
    public final static String order_status_wait_comfirm = "15";
    /**
     * 订单状态：{@value}接口异常
     * 接口异常从50开始
     * 确认预占库存失败
     */
    public final static String order_status_interface_confirm_order_error = "50";
    /**
     * 订单状态：{@value}接口异常
     * 接口异常从50开始
     * 预占库存失败
     */
    public final static String order_status_interface_create_order_error = "51";

    /**
     * 订单状态：{@value}接口异常
     * 接口异常从50开始
     * 积分扣减失败
     */
    public final static String order_status_interface_deduct_score_error = "52";
    /**
     * 拼团待成团
     */
    public final static String order_status_wait_for_group = "100";
    /**
     * 拼团已成团
     */
    //public final static String order_status_finish_grouped = "101";

    public final static String STORE_TYPE_SUPPLIER = "1";
    public final static String STORE_TYPE_PROTOCOL = "2";
    // 竞价订单
    public final static String STORE_TYPE_BIDDING = "3";
    // 批量订单
    public final static String STORE_TYPE_BATCH = "4";

    static {
        order_status.put(order_status_neworder, "新建订单");
        order_status.put(order_status_obligation, "待付款");
        order_status.put(order_status_ounfilled, "待收货");//-------映射提现   处理中  --提现后台 待提现
        order_status.put(order_status_notdeliver, "待收货");
        order_status.put(order_status_evaluate, "已收货");
        order_status.put(order_status_finish, "已完成");   //-------映射提现  提现成功
        order_status.put(order_status_cancel, "已取消");
        order_status.put(order_status_refuse, "拒收");
        order_status.put(order_status_outoftime_cancel, "已取消");
        order_status.put(order_status_error, "错误");
        order_status.put(order_status_noPass, "审核不通过");
        order_status.put(order_status_inCheck, "审核中");
        order_status.put(order_status_tixinFail, "提现失败");
        order_status.put(order_status_Weihu, "维护中");      // 映射提现 后台 可维护
        order_status.put(order_status_return, "退货");      // 映射提现 后台 可维护
        order_status.put(order_status_wait_comfirm, "待确认");
        order_status.put(order_status_interface_confirm_order_error, "确认预占库存失败");
        order_status.put(order_status_interface_create_order_error, "预占库存失败");
        order_status.put(order_status_interface_deduct_score_error, "积分扣减失败");
        order_status.put(order_status_wait_for_group, "待成团");
//        order_status.put(order_status_finish_grouped, "已成团");
    }

    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    @Column(length = 36)
    protected String id;


    @Column(length = 36, name = "payment_id")
    private String paymentId;

    @Column(length = 36, name = "member_id")
    private String memberId;

    @Column(length = 36, name = "store_id")
    private String storeId;

    @Column(length = 36, name = "address_id")
    private String addressId;

    @Column(length = 36, name = "order_no")
    private String orderNo;

    /**
     * 订单状态
     */
    @Column(length = 10)
    private String status;


    /**
     * 第三方订单状态
     */
    @Column(length = 10)
    private String trdSpStatus;


    /**
     * 第三方订单的appId
     */
    @Column(length = 255)
    private String appId;

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    /**
     * 收款状态
     * 1.已收款 2.待收款
     */
    @Column(length = 10)
    private Integer receiptStatus;

    /**
     * 第三方商户下单状态
     * 0-- 未处理 1-- 第三方处理成功 2-- 第三方处理失败
     */
    @Column(length = 10)
    private String outsideStatus;

    /**
     * 订单处理错误重试次数（第三方下单等外部商户订单接口操作时的最重试次数）
     */
    private Integer retryCounts;

    /**
     * 最后一次处理时间戳（第三方下单等外部商户订单接口操作的最后一次调用时间）
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date lastHandleTime;

    /**
     * 订单总金额（包含运费）
     */
    @Column(scale = 2)
    private BigDecimal sumPrice; //

    /**
     * 订单商品总价（不含运费）
     */
    @Column(scale = 2)
    private BigDecimal sumNofreightPrice; //

    /**
     * 订单商品总重量（预留）
     */
    @Column(scale = 2)
    private BigDecimal weight;

    /**
     * 订单基本运费
     */
    @Column(scale = 2)
    private BigDecimal freight;

    /**
     * 订单已抵扣积分
     */
    private BigDecimal score;

    /**
     * 第三方订单金额
     */
    @Column(scale = 2)
    private BigDecimal orderPrice;

    /**
     * 订单总积分   与score类型不同
     */
    private BigDecimal commonScore;
    /**
     * 真实机构代码，区分pc移动端
     */
    private String realOrganizationId;

    /**
     * 重新计算订单金额
     */
    public void reCalSumPrice() {
        this.freight = (this.freight == null ? BigDecimal.ZERO : this.freight).setScale(2, BigDecimal.ROUND_HALF_UP);
        this.sumNofreightPrice = (this.sumNofreightPrice == null ? BigDecimal.ZERO : this.sumNofreightPrice).setScale(2, BigDecimal.ROUND_HALF_UP);
        this.freeFreight = (this.freeFreight == null ? BigDecimal.ZERO : this.freeFreight).setScale(2, BigDecimal.ROUND_HALF_UP);
        this.sumPrice = (this.sumNofreightPrice.add(this.freight).subtract(this.freeFreight)).setScale(2, BigDecimal.ROUND_HALF_UP);
    }

    public BigDecimal getOrderPrice() {
        return orderPrice;
    }

    public void setOrderPrice(BigDecimal orderPrice) {
        this.orderPrice = orderPrice;
    }

    /**
     * 预留字段，下单客户端ip
     */
    @Column(length = 20)
    private String ip;

    /**
     * 订单创建时间
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date createTime; //

    /**
     * 订单完成时间
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date finishedTime; //

    /**
     * 订单评价
     */
    private String comments; //

    /**
     * 物流派送开始时间
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date shippingTime; //

    /**
     * 物流投妥时间
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date shippingComfirmTime; //

    /**
     * 订单关联产品名称（预留）
     */
    private String productName; //

    /**
     * 第三方物流编号（预留）
     */
    @Column(length = 50)
    private String tradeNo; //

    /**
     * 是否申请售后（预留）
     */
    private Boolean isAfter; //

    /**
     * 是否已投妥，当物流配送投妥后回写true
     */
    private Boolean isDeliver = false;

    /**
     * 支付方式，用于积分商城里面
     * 太平商城 1：后付费  2：在线支付
     */
    private String payMethod;
    /**
     * 对账状态
     */
    private String pstatus;

    /**
     * 京东对账状态
     */
    private String jdstatus;

    /**
     * MemberInVoice表ID
     */
    @Column(length = 36)
    private String invoiceId;

    /**
     * 减免运费（预留）
     * 未有运费减免时为0，默认值为0
     */
    @Column(scale = 2)
    private BigDecimal freeFreight = BigDecimal.ZERO; //

    /**
     * 是否退货
     */
    private Boolean isRefunded; //

    /**
     * 是否需要进行审核
     */
    private Boolean auditFlag = true;

    /**
     * 订单商品列表
     */
    @OneToMany(cascade = CascadeType.ALL, fetch = FetchType.EAGER, mappedBy = "order")
    private List<OrderItem> orderItems;

    /**
     * 子订单列表
     */
    @OneToMany(fetch = FetchType.LAZY, cascade = CascadeType.ALL, mappedBy = "order")
    private List<SubOrder> subOrders;

    /**
     * 订单礼品列表（预留）
     */
    @OneToMany(mappedBy = "order", fetch = FetchType.LAZY)
    private List<OrderGift> orderGifts;

    /**
     * 订单属性表，用于灵活属性扩展
     */
    @OneToMany(mappedBy = "order", fetch = FetchType.LAZY, cascade = CascadeType.ALL)
    private List<OrderMainAttr> orderAttrs;

    /**
     * 第三方供应商订单号（如京东、苏宁的订单号）
     */
    @Column(name = "third_order_no")
    private String thirdOrderNo; //

    /**
     * 机构代码
     */
    @Column(name = "organization_id")
    private String organizationId; //

    /**
     * 订单用途（采购）
     * <br>1：资产
     * <br>2：激励品
     * <br>3：福利
     */
    private String usageCode; //

    /**
     * 机构Id
     */
    @Column(name = "company_id")
    private String companyId;

    /**
     * 部门Id
     */
    private String departId;

    /**
     * 发送信息标记  0 ：未发送   1：已发送
     */
    @Column(columnDefinition = "nvarchar(3) default 0")
    private String sendSms;

    /**
     * 第一个审核人员审核处理时间
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date firstAuditTime;

    /**
     * 工作流审核完成时间（最后一个审核人员审核处理时间）
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date auditEndTime;

    /**
     * 购买类型 ipad,mobile,pc
     */
    @Column(name = "buy_type", length = 10)
    private String buyType;

    /**
     * 用来记录网页头信息
     */
    @Column(name = "head_message")
    private String headMessage;

    /**
     * 浏览器类型
     */
    @Column(name = "browser_type")
    private String browserType;
    /**
     * 平台类型
     */
    @Column(name = "platform_type")
    private String platformType;

    /**
     * 订单收件人姓名
     */
    private String recipientName;

    /**
     * 订单收件人电话
     */
    private String recipientPhone;

    /**
     * 订单店铺类型
     */
    private String storeType;

    /**
     * 订单店铺名称
     */
    private String storeName;

    /**
     * 订单的店铺代码
     */
    private String storeCode;

    /**
     * 是否已创建账单标志
     */
    private Boolean billsCreated;

    /**
     * 请求参数信息
     * ALTER TABLE order_main ADD ( "POST_DESC" CLOB );
     */
    @Column(name = "post_desc", columnDefinition = "clob")
    @Type(type = "text")
    private String postDesc;

    /**
     * 创建订单请求ID
     * 用于订单防重
     */
    @Column(name = "request_id")
    private String requestId;

    /**
     * 账单申请id
     */
    @Column(name = "bills_request_id")
    private String billsRequestId;

    private Boolean haveReview;

    /**
     * 订单类型
     */
    private String orderType;

    /**
     * 下单时使用的GoodsType
     */
    private String goodsType;

    /**
     * 订单模式，1 常规订单 | 2 批量订单 等
     */
    @Column(name = "ORDER_MODE")
    public String orderMode;

    /**
     * 父订单id
     */
    private String parentOrderId;

    /**
     * 库存预定单号
     */
    private String reservationCode;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        OrderMain orderMain = (OrderMain) o;

        return !(id != null ? (!id.equals(orderMain.id) ? false : (orderNo.equals(orderMain.orderNo))) : orderMain.id != null);
    }

    @Override
    public int hashCode() {
        int result = Lang.isEmpty(id) ? 0 : id.hashCode();
        result = 31 * result + (Lang.isEmpty(orderNo) ? 0 : orderNo.hashCode());
        return result;
    }

    /**
     * 新增地址详细信息
     */
    @Column(name = "ADDRESS_NAME")
    private String addressName;

   /* @Override
    public String toString() {
        return "OrderMain{" +
                "id='" + id + '\'' +
                ", paymentId='" + paymentId + '\'' +
                ", memberId='" + memberId + '\'' +
                ", storeId='" + storeId + '\'' +
                ", addressId='" + addressId + '\'' +
                ", addressName='" + addressName + '\'' +
                ", orderNo='" + orderNo + '\'' +
                ", status='" + status + '\'' +
                ", receiptStatus=" + receiptStatus +
                ", outsideStatus='" + outsideStatus + '\'' +
                ", retryCounts=" + retryCounts +
                ", lastHandleTime=" + lastHandleTime +
                ", sumPrice=" + sumPrice +
                ", sumNofreightPrice=" + sumNofreightPrice +
                ", weight=" + weight +
                ", freight=" + freight +
                ", score=" + score +
                ", orderPrice=" + orderPrice +
                ", commonScore=" + commonScore +
                ", realOrganizationId='" + realOrganizationId + '\'' +
                ", ip='" + ip + '\'' +
                ", createTime=" + createTime +
                ", finishedTime=" + finishedTime +
                ", comments='" + comments + '\'' +
                ", shippingTime=" + shippingTime +
                ", shippingComfirmTime=" + shippingComfirmTime +
                ", productName='" + productName + '\'' +
                ", tradeNo='" + tradeNo + '\'' +
                ", isAfter=" + isAfter +
                ", isDeliver=" + isDeliver +
                ", payMethod='" + payMethod + '\'' +
                ", pstatus='" + pstatus + '\'' +
                ", jdstatus='" + jdstatus + '\'' +
                ", invoiceId='" + invoiceId + '\'' +
                ", freeFreight=" + freeFreight +
                ", isRefunded=" + isRefunded +
                ", auditFlag=" + auditFlag +
                ", orderItems=" + orderItems +
                ", subOrders=" + subOrders +
                ", orderGifts=" + orderGifts +
                ", orderAttrs=" + orderAttrs +
                ", thirdOrderNo='" + thirdOrderNo + '\'' +
                ", organizationId='" + organizationId + '\'' +
                ", usageCode='" + usageCode + '\'' +
                ", companyId='" + companyId + '\'' +
                ", departId='" + departId + '\'' +
                ", sendSms='" + sendSms + '\'' +
                ", firstAuditTime=" + firstAuditTime +
                ", auditEndTime=" + auditEndTime +
                ", buyType='" + buyType + '\'' +
                ", headMessage='" + headMessage + '\'' +
                ", browserType='" + browserType + '\'' +
                ", platformType='" + platformType + '\'' +
                ", recipientName='" + recipientName + '\'' +
                ", recipientPhone='" + recipientPhone + '\'' +
                ", storeType='" + storeType + '\'' +
                ", storeName='" + storeName + '\'' +
                ", storeCode='" + storeCode + '\'' +
                ", postDesc='" + postDesc + '\'' +
                '}';
    }*/

    public String getAddressName() {
        return addressName;
    }

    public void setAddressName(String addressName) {
        this.addressName = addressName;
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPaymentId() {
        return this.paymentId;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public String getMemberId() {
        return this.memberId;
    }

    public String getParentOrderId() {
        return parentOrderId;
    }

    public void setParentOrderId(String parentOrderId) {
        this.parentOrderId = parentOrderId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public String getAddressId() {
        return this.addressId;
    }

    public void setAddressId(String addressId) {
        this.addressId = addressId;
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    /**
     * 获取 订单状态
     */
    public String getStatus() {
        return this.status;
    }

    /**
     * 设置 订单状态
     */
    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * 收款状态
     * 1.已收款 2.待收款
     */
    public Integer getReceiptStatus() {
        return this.receiptStatus;
    }

    /**
     * 收款状态
     * 1.已收款 2.待收款
     */
    public void setReceiptStatus(Integer receiptStatus) {
        this.receiptStatus = receiptStatus;
    }

    /**
     * 第三方商户下单状态
     * 0-- 未处理 1-- 第三方处理成功 2-- 第三方处理失败
     */
    public String getOutsideStatus() {
        return this.outsideStatus;
    }

    /**
     * 第三方商户下单状态
     * 0-- 未处理 1-- 第三方处理成功 2-- 第三方处理失败
     */
    public void setOutsideStatus(String outsideStatus) {
        this.outsideStatus = outsideStatus;
    }

    /**
     * 获取 订单处理错误重试次数（第三方下单等外部商户订单接口操作时的最重试次数）
     */
    public Integer getRetryCounts() {
        return this.retryCounts;
    }

    /**
     * 设置 订单处理错误重试次数（第三方下单等外部商户订单接口操作时的最重试次数）
     */
    public void setRetryCounts(Integer retryCounts) {
        this.retryCounts = retryCounts;
    }

    /**
     * 获取 最后一次处理时间戳（第三方下单等外部商户订单接口操作的最后一次调用时间）
     */
    public Date getLastHandleTime() {
        return this.lastHandleTime;
    }

    /**
     * 设置 最后一次处理时间戳（第三方下单等外部商户订单接口操作的最后一次调用时间）
     */
    public void setLastHandleTime(Date lastHandleTime) {
        this.lastHandleTime = lastHandleTime;
    }

    /**
     * 获取 订单总金额（包含运费）
     */
    public BigDecimal getSumPrice() {
        return this.sumPrice;
    }

    /**
     * 设置 订单总金额（包含运费）
     */
    public void setSumPrice(BigDecimal sumPrice) {
        this.sumPrice = sumPrice;
    }

    /**
     * 获取 订单商品总价（不含运费）
     */
    public BigDecimal getSumNofreightPrice() {
        return this.sumNofreightPrice;
    }

    /**
     * 设置 订单商品总价（不含运费）
     */
    public void setSumNofreightPrice(BigDecimal sumNofreightPrice) {
        this.sumNofreightPrice = sumNofreightPrice;
    }

    /**
     * 获取 订单商品总重量（预留）
     */
    public BigDecimal getWeight() {
        return this.weight;
    }

    /**
     * 设置 订单商品总重量（预留）
     */
    public void setWeight(BigDecimal weight) {
        this.weight = weight;
    }

    /**
     * 获取 订单基本运费
     */
    public BigDecimal getFreight() {
        return this.freight;
    }

    /**
     * 设置 订单基本运费
     */
    public void setFreight(BigDecimal freight) {
        this.freight = freight;
    }

    /**
     * 获取 订单已抵扣积分
     */
    public BigDecimal getScore() {
        return this.score;
    }

    /**
     * 设置 订单已抵扣积分
     */
    public void setScore(BigDecimal score) {
        this.score = score;
    }

    /**
     * 获取 订单总积分   与score类型不同
     */
    public BigDecimal getCommonScore() {
        return this.commonScore;
    }

    /**
     * 设置 订单总积分   与score类型不同
     */
    public void setCommonScore(BigDecimal commonScore) {
        this.commonScore = commonScore;
    }

    /**
     * 获取 预留字段，下单客户端ip
     */
    public String getIp() {
        return this.ip;
    }

    /**
     * 设置 预留字段，下单客户端ip
     */
    public void setIp(String ip) {
        this.ip = ip;
    }

    /**
     * 获取 订单创建时间
     */
    public Date getCreateTime() {
        return this.createTime;
    }

    /**
     * 设置 订单创建时间
     */
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 获取 订单完成时间
     */
    public Date getFinishedTime() {
        return this.finishedTime;
    }

    /**
     * 设置 订单完成时间
     */
    public void setFinishedTime(Date finishedTime) {
        this.finishedTime = finishedTime;
    }

    /**
     * 获取 订单评价
     */
    public String getComments() {
        return this.comments;
    }

    /**
     * 设置 订单评价
     */
    public void setComments(String comments) {
        this.comments = comments;
    }

    /**
     * 获取 物流派送开始时间
     */
    public Date getShippingTime() {
        return this.shippingTime;
    }

    /**
     * 设置 物流派送开始时间
     */
    public void setShippingTime(Date shippingTime) {
        this.shippingTime = shippingTime;
    }

    /**
     * 获取 物流投妥时间
     */
    public Date getShippingComfirmTime() {
        return this.shippingComfirmTime;
    }

    /**
     * 设置 物流投妥时间
     */
    public void setShippingComfirmTime(Date shippingComfirmTime) {
        this.shippingComfirmTime = shippingComfirmTime;
    }

    /**
     * 获取 订单关联产品名称（预留）
     */
    public String getProductName() {
        return this.productName;
    }

    /**
     * 设置 订单关联产品名称（预留）
     */
    public void setProductName(String productName) {
        this.productName = productName;
    }

    /**
     * 获取 第三方物流编号（预留）
     */
    public String getTradeNo() {
        return this.tradeNo;
    }

    /**
     * 设置 第三方物流编号（预留）
     */
    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    /**
     * 获取 是否申请售后（预留）
     */
    public Boolean getAfter() {
        return this.isAfter;
    }

    /**
     * 设置 是否申请售后（预留）
     */
    public void setAfter(Boolean isAfter) {
        this.isAfter = isAfter;
    }

    /**
     * 获取 是否已投妥，当物流配送投妥后回写true
     */
    public Boolean getDeliver() {
        return this.isDeliver;
    }

    /**
     * 设置 是否已投妥，当物流配送投妥后回写true
     */
    public void setDeliver(Boolean isDeliver) {
        this.isDeliver = isDeliver;
    }

    /**
     * 设置 是否已投妥，当物流配送投妥后回写true
     */
    public void setIsDeliver(Boolean isDeliver) {
        this.isDeliver = isDeliver;
    }


    /**
     * 支付方式，用于积分商城里面
     * 太平商城 1：后付费  2：在线支付
     */
    public String getPayMethod() {
        return this.payMethod;
    }

    /**
     * 支付方式，用于积分商城里面
     * 太平商城 1：后付费  2：在线支付
     */
    public void setPayMethod(String payMethod) {
        this.payMethod = payMethod;
    }

    /**
     * 获取 对账状态
     */
    public String getPstatus() {
        return this.pstatus;
    }

    /**
     * 设置 对账状态
     */
    public void setPstatus(String pstatus) {
        this.pstatus = pstatus;
    }

    /**
     * 获取 京东对账状态
     */
    public String getJdstatus() {
        return this.jdstatus;
    }

    /**
     * 设置 京东对账状态
     */
    public void setJdstatus(String jdstatus) {
        this.jdstatus = jdstatus;
    }

    /**
     * 获取 MemberInVoice表ID
     */
    public String getInvoiceId() {
        return this.invoiceId;
    }

    /**
     * 设置 MemberInVoice表ID
     */
    public void setInvoiceId(String invoiceId) {
        this.invoiceId = invoiceId;
    }

    /**
     * 减免运费（预留）
     * 未有运费减免时为0，默认值为0
     */
    public BigDecimal getFreeFreight() {
        return this.freeFreight;
    }

    /**
     * 减免运费（预留）
     * 未有运费减免时为0，默认值为0
     */
    public void setFreeFreight(BigDecimal freeFreight) {
        this.freeFreight = freeFreight;
    }

    /**
     * 获取 是否退货
     */
    public Boolean getIsRefunded() {
        return this.isRefunded;
    }

    /**
     * 设置 是否退货
     */
    public void setIsRefunded(Boolean isRefunded) {
        this.isRefunded = isRefunded;
    }

    /**
     * 获取 订单商品列表
     */
    public List<OrderItem> getOrderItems() {
        return this.orderItems;
    }

    /**
     * 设置 订单商品列表
     */
    public void setOrderItems(List<OrderItem> orderItems) {
        this.orderItems = orderItems;
    }

    /**
     * 获取 子订单列表
     */
    public List<SubOrder> getSubOrders() {
        return this.subOrders;
    }

    /**
     * 设置 子订单列表
     */
    public void setSubOrders(List<SubOrder> subOrders) {
        this.subOrders = subOrders;
    }

    /**
     * 获取 订单礼品列表（预留）
     */
    public List<OrderGift> getOrderGifts() {
        return this.orderGifts;
    }

    /**
     * 设置 订单礼品列表（预留）
     */
    public void setOrderGifts(List<OrderGift> orderGifts) {
        this.orderGifts = orderGifts;
    }

    /**
     * 获取 订单属性表，用于灵活属性扩展
     */
    public List<OrderMainAttr> getOrderAttrs() {
        return this.orderAttrs;
    }

    /**
     * 设置 订单属性表，用于灵活属性扩展
     */
    public void setOrderAttrs(List<OrderMainAttr> orderAttrs) {
        this.orderAttrs = orderAttrs;
    }

    /**
     * 获取 第三方供应商订单号（如京东、苏宁的订单号）
     */
    public String getThirdOrderNo() {
        return this.thirdOrderNo;
    }

    /**
     * 设置 第三方供应商订单号（如京东、苏宁的订单号）
     */
    public void setThirdOrderNo(String thirdOrderNo) {
        this.thirdOrderNo = thirdOrderNo;
    }

    /**
     * 获取 机构代码
     */
    public String getOrganizationId() {
        return this.organizationId;
    }

    /**
     * 设置 机构代码
     */
    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    /**
     * 订单用途（采购）
     * <br>1：资产
     * <br>2：激励品
     * <br>3：福利
     */
    public String getUsageCode() {
        return this.usageCode;
    }

    /**
     * 订单用途（采购）
     * <br>1：资产
     * <br>2：激励品
     * <br>3：福利
     */
    public void setUsageCode(String usageCode) {
        this.usageCode = usageCode;
    }

    /**
     * 获取 机构Id
     */
    public String getCompanyId() {
        return this.companyId;
    }

    /**
     * 设置 机构Id
     */
    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    /**
     * 获取 部门Id
     */
    public String getDepartId() {
        return this.departId;
    }

    /**
     * 设置 部门Id
     */
    public void setDepartId(String departId) {
        this.departId = departId;
    }

    /**
     * 获取 发送信息标记  0 ：未发送   1：已发送
     */
    public String getSendSms() {
        return this.sendSms;
    }

    /**
     * 设置 发送信息标记  0 ：未发送   1：已发送
     */
    public void setSendSms(String sendSms) {
        this.sendSms = sendSms;
    }

    /**
     * 获取 工作流审核完成时间
     */
    public Date getAuditEndTime() {
        return this.auditEndTime;
    }

    /**
     * 设置 工作流审核完成时间
     */
    public void setAuditEndTime(Date auditEndTime) {
        this.auditEndTime = auditEndTime;
    }

    /**
     * 获取 第一个审核人员审核处理时间
     */
    public Date getFirstAuditTime() {
        return this.firstAuditTime;
    }

    /**
     * 设置 第一个审核人员审核处理时间
     */
    public void setFirstAuditTime(Date firstAuditTime) {
        this.firstAuditTime = firstAuditTime;
    }


    public String getRealOrganizationId() {
        return realOrganizationId;
    }

    public void setRealOrganizationId(String realOrganizationId) {
        this.realOrganizationId = realOrganizationId;
    }

    public Boolean getRefunded() {
        return isRefunded;
    }

    public void setRefunded(Boolean refunded) {
        isRefunded = refunded;
    }

    public String getBuyType() {
        return buyType;
    }

    public void setBuyType(String buyType) {
        this.buyType = buyType;
    }

    public String getHeadMessage() {
        return headMessage;
    }

    public void setHeadMessage(String headMessage) {
        this.headMessage = headMessage;
    }

    public String getBrowserType() {
        return browserType;
    }

    public void setBrowserType(String browserType) {
        this.browserType = browserType;
    }

    public String getPlatformType() {
        return platformType;
    }

    public void setPlatformType(String platformType) {
        this.platformType = platformType;
    }

    public String getPostDesc() {
        return postDesc;
    }

    public void setPostDesc(String postDesc) {
        this.postDesc = postDesc;
    }

    public String getRequestId() {
        return requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public Boolean getAuditFlag() {
        return auditFlag;
    }

    public void setAuditFlag(Boolean auditFlag) {
        this.auditFlag = auditFlag;
    }

    public String getRecipientName() {
        return recipientName;
    }

    public void setRecipientName(String recipientName) {
        this.recipientName = recipientName;
    }

    public String getRecipientPhone() {
        return recipientPhone;
    }

    public void setRecipientPhone(String recipientPhone) {
        this.recipientPhone = recipientPhone;
    }

    public String getStoreType() {
        return storeType;
    }

    public void setStoreType(String storeType) {
        this.storeType = storeType;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public String getStoreCode() {
        return storeCode;
    }

    public void setStoreCode(String storeCode) {
        this.storeCode = storeCode;
    }

    public Boolean getHaveReview() {
        return haveReview;
    }

    public void setHaveReview(Boolean haveReview) {
        this.haveReview = haveReview;
    }

    public Boolean getBillsCreated() {
        return billsCreated;
    }

    public void setBillsCreated(Boolean billsCreated) {
        this.billsCreated = billsCreated;
    }

    public String getBillsRequestId() {
        return billsRequestId;
    }

    public void setBillsRequestId(String billsRequestId) {
        this.billsRequestId = billsRequestId;
    }


    public String getTrdSpStatus() {
        return trdSpStatus;
    }

    public void setTrdSpStatus(String trdSpStatus) {
        this.trdSpStatus = trdSpStatus;
    }

    public String getGoodsType() {
        return goodsType;
    }

    public void setGoodsType(String goodsType) {
        this.goodsType = goodsType;
    }

    public String getOrderMode() {
        return orderMode;
    }

    public void setOrderMode(String orderMode) {
        this.orderMode = orderMode;
    }

    public String getReservationCode() {
        return reservationCode;
    }

    public void setReservationCode(String reservationCode) {
        this.reservationCode = reservationCode;
    }
}
