package order.model.po;

import order.model.po.base.BaseDomain;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * Created by Roney on 2017-08-28.
 *
 * 记录商品比较信息
 */
@Entity
@Table(indexes = {
        @Index(name = "idx_order_parity_store_id", columnList = "store_id")
})
public class OrderParity  extends BaseDomain implements Serializable {

    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    @Column(length = 36)
    protected String id;


    @ManyToOne
    @JoinColumn(name = "order_item_id", foreignKey = @ForeignKey(name = "fk_o_parity_item"))
    private OrderItem orderItem;

    /**
     * 店铺
     */
    @Column(name ="store_id")
    private String storeId;

    @Column(length = 36, name = "product_id")
    private String productId;
    @Column(length = 36, name = "goods_id")
    private String goodsId;

    private String productName;    //包括规格
    @Column(length = 36, name = "product_fash_id")
    private String productFashId;

    /**
     * 供应商货物编码，如京东、苏宁的skuId
     */
    private String sku;

    /**
     * 商品的名称
     */
    private String name;

    /**
     * 协议价
     */
    @Column(scale = 2)
    private BigDecimal costPrice;

    /**
     * 太平净价
     */
    @Column(scale = 2)
    private BigDecimal salePrice;

    @Column(scale = 2)
    private BigDecimal rate;

    /**
     * 下单时商品销售价格浮动比例
     */
    @Column(scale = 2)
    private BigDecimal salePriceRate;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getStoreId() {
        return storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public String getProductId() {
        return productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getGoodsId() {
        return goodsId;
    }

    public void setGoodsId(String goodsId) {
        this.goodsId = goodsId;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductFashId() {
        return productFashId;
    }

    public void setProductFashId(String productFashId) {
        this.productFashId = productFashId;
    }

    public String getSku() {
        return sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal getCostPrice() {
        return costPrice;
    }

    public void setCostPrice(BigDecimal costPrice) {
        this.costPrice = costPrice;
    }

    public BigDecimal getSalePriceRate() {
        return salePriceRate;
    }

    public void setSalePriceRate(BigDecimal salePriceRate) {
        this.salePriceRate = salePriceRate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        OrderParity that = (OrderParity) o;

        return id != null ? id.equals(that.id) : that.id == null;

    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }

    public OrderItem getOrderItem() {
        return orderItem;
    }

    public void setOrderItem(OrderItem orderItem) {
        this.orderItem = orderItem;
    }


    public BigDecimal getSalePrice() {
        return salePrice;
    }

    public void setSalePrice(BigDecimal salePrice) {
        this.salePrice = salePrice;
    }

    public BigDecimal getRate() {
        return rate;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }
}
