package order.model.po;

import lombok.Data;
import order.model.po.base.BaseDomain;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;

import java.io.Serializable;

/**
 * 订单操作模型适配器配置表
 *
 * @author Liang Wenxu
 * @since 2018/7/9
 */
@Entity
@Table(name = "ORDER_TEMPLATE_ADAPTER_CONFIG", indexes = {
        //唯一索引，控制同个店铺只能配置唯一有效的适配器
        @Index(name = "IDX_UN_ORDER_TPL_ADAPTER_CFG", columnList = "ORDER_MODE,GOODS_TYPE,ORG_CODE,TEMPLATE_NAME,TEMPLATE_CLASS,is_delete,enabled", unique = true),
        //组合查询索引，优化指定店铺、名称的查询速度
        @Index(name = "IDX_Q_ORDER_TPL_CLZ", columnList = "ORDER_MODE,GOODS_TYPE,ORG_CODE,TEMPLATE_NAME"),
        //组合查询索引，优化指定店铺、模板类的查询速度
        @Index(name = "IDX_Q_ORDER_TPL_NAME", columnList = "ORDER_MODE,GOODS_TYPE,ORG_CODE,TEMPLATE_CLASS"),
        //组合查询索引，优化有效模板配置的查询速度
        @Index(name = "IDX_Q_ORDER_VALID_TPL", columnList = "ORDER_MODE,GOODS_TYPE,ORG_CODE,is_delete,enabled"),
        //查询索引，优化店铺代码查询速度
        @Index(name = "IDX_Q_ORDER_VALID_TPL", columnList = "ORDER_MODE,GOODS_TYPE,ORG_CODE")
})
@Data
public class OrderTemplateAdapterConfig extends BaseDomain implements Serializable {
    private static final long serialVersionUID = -4246473956494579317L;
    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    @Column(length = 36)
    private String id;

    /**
     * 订单模式（常规下单（单个订单）、批量下单等）
     */
    @Column(name = "ORDER_MODE", nullable = false)
    public String orderMode;

    /**
     * 商品类型
     */
    @Column(name = "GOODS_TYPE", nullable = false)
    public String goodsType;

    /**
     * 渠道代码
     */
    @Column(name = "ORG_CODE", nullable = false)
    public String orgCode;

    /**
     * 订单处理模板类名（全称，包括包名）
     */
    @Column(name = "TEMPLATE_CLASS", nullable = false)
    public String templateClass;

    /**
     * 订单处理模板名（用作处理模板类的BeanName）
     */
    @Column(name = "TEMPLATE_NAME", nullable = false)
    public String templateName;

    /**
     * 是否启用
     */
    @Column(name = "enabled", nullable = false)
    public Boolean enabled;

    /**
     * 备注
     */
    public String remarks;
}