package order.model.po;


import lombok.Data;
import order.model.po.base.BaseDomain;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author: taofeng
 * @create: 2018-05-09
 **/
@Data
@Entity
public class Quota extends BaseDomain implements Serializable {

    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    @Column(length = 36)
    private String id;

    /**
     * 商品三级分类id
     */
    private String productcategoryId;

    /**
     * 机构id
     */
    private String companyId;

    /**
     * 当前限额额度
     */
    private BigDecimal currentQuota;

    /**
     * 当前累积额度
     */
    private BigDecimal sumQuota;

}
