package order.model.po;

import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * Created by xiaoqian on 2016/9/28.
 */
@Entity
@Table
public class SubOrderItem implements Serializable {

    public static final Integer TYPE_GENERAL=0;//普通
    public static final Integer TYPE_ATTACHMENT=1;//附件
    public static final Integer TYPE_GIFT=2;//赠品

    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    @Column(length = 36)
    protected String id;

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "order_id",foreignKey = @ForeignKey(name = "fk_sub_o_item_order"))
    private OrderMain order;

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "sub_order_id",foreignKey = @ForeignKey(name = "fk_sub_o_item_suborder"))
    private SubOrder subOrder;

    @ManyToOne(fetch = FetchType.EAGER)
    @JoinColumn(name = "order_item_id",foreignKey = @ForeignKey(name = "fk_sub_o_order_item_id"))
    private OrderItem orderItem;

    /**
     * 数量
     */
    private Integer count;

    /**
     * type为0普通、1附件、2赠品
     */
    private Integer type;

    /**
     * 商品的价格
     */
    private BigDecimal price;

    /**
     *  商品的名称
     */
    private String name;

    /**
     * 商品的税额
     */
    private BigDecimal taxPrice;

    /**
     * 商品的编码
     */
    private String skuId;

    /**
     *  商品价格-税额
     */
    private BigDecimal nakedPrice;


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        SubOrderItem that = (SubOrderItem) o;

        return !(id != null ? !id.equals(that.id) : that.id != null);

    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getCount() {
        return count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public OrderMain getOrder() {
        return order;
    }

    public void setOrder(OrderMain order) {
        this.order = order;
    }

    public SubOrder getSubOrder() {
        return subOrder;
    }

    public void setSubOrder(SubOrder subOrder) {
        this.subOrder = subOrder;
    }

    public OrderItem getOrderItem() {
        return orderItem;
    }

    public void setOrderItem(OrderItem orderItem) {
        this.orderItem = orderItem;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }

    public String getSkuId() {
        return skuId;
    }

    public void setSkuId(String skuId) {
        this.skuId = skuId;
    }

    public BigDecimal getNakedPrice() {
        return nakedPrice;
    }

    public void setNakedPrice(BigDecimal nakedPrice) {
        this.nakedPrice = nakedPrice;
    }
}
