package order.model.repository;

import order.model.po.MallParentOrder;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author junyang.dong
 * @version v1.0
 * @date 2018/5/9
 * 商城父订单表
 */
public interface MallParentOrderRepo extends JpaRepository<MallParentOrder,String>,JpaSpecificationExecutor<MallParentOrder> {

    @Modifying
    @Transactional
    @Query(value = "update Mall_Parent_Order p set p.status=?1 where p.id=?2",nativeQuery = true)
    int changeOrderStatus(String status,String id);

}
