package order.model.repository;

import order.model.po.MallTempOrder;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author junyang.dong
 * @version v1.0
 * @date 2018/5/9
 * 商城临时订单表
 */
public interface MallTempOrderRepo extends JpaRepository<MallTempOrder,String>,JpaSpecificationExecutor<MallTempOrder> {

    @Query("select o from MallTempOrder o where o.memberId=:memberId order by o.dateCreated asc ")
    List<MallTempOrder> findByMemberId(@Param("memberId") String memberId);
   // List<MallTempOrder> findByMemberId(String memberId);

    void deleteByIdIn(List<String> ids);

    MallTempOrder findById(String id);

    void deleteAllByMemberId(String memberId);

    @Modifying
    @Transactional
    @Query(value = "update MALL_TEMP_ORDER m set m.ERROR_INFO=?1 where m.MEMBER_ADDRESS_ID=?2 and m.MEMBER_ID=?3",nativeQuery = true)
    int updateTempOrder(String errorInfo, String memberAddressId, String memberId);
}
