package order.model.repository;

import order.model.po.OrderItem;
import order.model.po.OrderMain;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;

import java.util.List;

/**
 * Created by xiaoqian on 2016/9/27.
 */
public interface OrderItemRepos extends JpaRepository<OrderItem,String> {
    List<OrderItem> findByOrderId(String id);

    List<OrderItem> findByOrderIdAndIsDiscussOrIsDiscussIsNull(String id, Boolean isDelete);

//    @Query("SELECT i FROM OrderItem i,OrderMain m WHERE i.orderId = m.id AND m.status != 6")
//    Page<OrderItem> findByGoodsId(String goodsId, Pageable pageable);

    //Page<OrderItem> findByGoodsIdAndOrder_StatusInAndOrder_IsDelete(String goodsId, List<String> statusList, Boolean isDelete ,Pageable pageable);

    Page<OrderItem> findByGoodsIdAndOrder_StatusAndOrder_IsDelete(String goodsId, String status, Boolean isDelete, Pageable pageable);

    Page<OrderItem> findByOrder(OrderMain order, Pageable pageable);

    Page<OrderItem> findByGoodsIdAndOrder_StatusInAndOrder_IsDeleteAndOrder_OrganizationId(String goodsId, List<String> statusList, Boolean isDelete, String organizationId, Pageable pageable);

    List<OrderItem> findByIdIn(List<String> ids);
    OrderItem findByOrderIdAndSku(String id, String Sku);
}
