package order.model.repository;

import order.model.po.OrderMain;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * Created by xiaoqian on 2016/9/27.
 */
public interface OrderRepos extends JpaRepository<OrderMain, String>, JpaSpecificationExecutor<OrderMain> {

    OrderMain findById(String id);

    List<OrderMain> findByIdIn(List<String> ids);

    OrderMain findByMemberIdAndId(String memberId, String orderId);

    List<OrderMain> findByInvoiceId(String invoceId);

    List<OrderMain> findByMemberId(String memberId);

    OrderMain findByOrderNo(String orderNo);

    OrderMain findByOrderNoAndStoreId(String orderNo, String storId);


    List<OrderMain> findOrderByIsDeliverAndPayMethodAndIsDelete(boolean isDeliver, String payMethod, boolean isDelete);

    List<OrderMain> findOrderByStatusAndIsDelete(String status, boolean isDelete);

    List<OrderMain> findByStoreIdAndStatusAndIsDelete(String storeId, String status, boolean isDelete);

    List<OrderMain> findByStoreIdAndStatusInAndIsDelete(String storeId, List<String> status, boolean isDelete);

    OrderMain findByOrderNoAndStatusIn(String orderNo, List<String> status);

    @Query("select t from OrderMain t where t.memberId = ?1 and t.status in(2,3,4,5,10) and t.createTime between to_date(?2,'yyyy-mm-dd HH24:mi:ss')  and to_date(?3,'yyyy-mm-dd HH24:mi:ss') and t.organizationId = ?4 and t.isDelete=0")
    Page findByCreatTimeBetween(String memberId, String startTime, String endTime, String orgCode, Pageable pageable);


    @Query("select t from OrderMain t where t.status in(2,3,4,5,10) and t.createTime between to_date(?1,'yyyy-mm-dd HH24:mi:ss')  and to_date(?2,'yyyy-mm-dd HH24:mi:ss') and t.organizationId = ?3 and t.isDelete=0")
    Page findByCreatTimeBetween(String startTime, String endTime, String orgCode, Pageable pageable);


    @Query("select t from OrderMain t where t.status in(2,3,4,5,10) and t.createTime between to_date(?1,'yyyy-mm-dd HH24:mi:ss')  and to_date(?2,'yyyy-mm-dd HH24:mi:ss') and t.memberId in ?3 and t.organizationId = ?4 and t.isDelete=0")
    Page findByCreatTimeBetween(String startTime, String endTime, List list, String orgCode, Pageable pageable);

    @Query("select t from OrderMain t where t.status in(2,3,4,5,10) and t.createTime between to_date(?1,'yyyy-mm-dd HH24:mi:ss')  and to_date(?2,'yyyy-mm-dd HH24:mi:ss') and t.organizationId = ?3 and t.companyId = ?4 and t.isDelete=0")
    Page findByCreatTimeBetweenAndCompanyId(String startTime, String endTime, String orgCode, String companyId, Pageable pageable);

    @Transactional
    @Modifying
    @Query(value = "UPDATE Order_Main om SET om.status=?1 WHERE om.order_No=?2",nativeQuery = true)
    int updateStatusByOrderNo(String status, String orderNo);

    @Transactional()
    @Modifying()
    @Query(value = "UPDATE Order_Main t SET t.status=:status WHERE t.order_No in :orderNos",nativeQuery = true)
    int updateBatchStatusByOrderNo(@Param("status") String status, @Param("orderNos") List<String> orderNos);


    @Query(value = "update Order_Main t set t.status =?1 where t.id =?2",nativeQuery = true)
    @Transactional()
    @Modifying()
    int updateStatusById(String status, String id);

    @Query(value = "update Order_Main t set t.trd_Sp_Status =?1 where t.id =?2",nativeQuery = true)
    @Transactional()
    @Modifying()
    int updateTrdSpStatusById(String trdSpStatus, String id);

    @Query(value = "update Order_Main t set t.trd_Sp_Status =?1 where t.order_No=?2 and t.store_Id=?3",nativeQuery = true)
    @Transactional()
    @Modifying()
    int updateTrdSpStatusByOrderNo(String trdSpStatus, String OrderNo, String storeId);

    /**
     * 批量更新
     *
     * @param status
     * @param orderNos
     * @return
     */
    @Query(value = "update Order_Main t set t.status =?1 ,t.last_Updated=?3 where t.order_No in ( ?2 )",nativeQuery = true)
    @Transactional()
    @Modifying()
    int batchUpdateStatusByOrderNos(String status, List<String> orderNos, Date lastUpdated);

    /**
     * 批量更新
     *
     * @param status
     * @param ids
     * @return
     */
    @Query(value = "update Order_Main t set t.status =?1 ,t.last_Updated=?3,t.shipping_Comfirm_Time=?3,t.isDeliver=?4 where t.id in ( ?2 )",nativeQuery = true)
    @Transactional()
    @Modifying()
    int batchUpdateStatusByIds(String status, List<String> ids, Date lastUpdated, Boolean isDeliver);

    /**
     * 根据订单号查询订单
     *
     * @param orderNoList
     * @return
     */
    public List<OrderMain> findByOrderNoIn(List<String> orderNoList);

    public Page<OrderMain> findByOrganizationIdAndIsDelete(String organizationId, Boolean isDelete, Pageable pageable);

    public Page<OrderMain> findByOrganizationIdAndDateCreatedGreaterThanAndDateCreatedLessThanAndStatusInAndIsDelete(String organizationId, Date startDateCreated, Date endDateCreated, List<String> status, Boolean isDelete, Pageable pageable);

    public Page<OrderMain> findByOrganizationIdAndDateCreatedLessThanAndStatusInAndIsDelete(String organizationId, Date endDateCreated, List<String> status, Boolean isDelete, Pageable pageable);

    public Page<OrderMain> findByOrganizationIdAndDateCreatedGreaterThanAndDateCreatedLessThanAndStatusInAndOrderNoAndIsDelete(String organizationId, Date startDateCreated, Date endDateCreated, List<String> status, String orderNo, Boolean isDelete, Pageable pageable);

    public Page<OrderMain> findByOrganizationIdAndDateCreatedGreaterThanAndDateCreatedLessThanAndStatusInAndMemberIdInAndIsDelete(String organizationId, Date startDateCreated, Date endDateCreated, List<String> status, List<String> memberIds, Boolean isDelete, Pageable pageable);

    public Page<OrderMain> findByOrganizationIdAndDateCreatedGreaterThanAndDateCreatedLessThanAndStatusInAndMemberIdInAndOrderNoAndIsDelete(String organizationId, Date startDateCreated, Date endDateCreated, List<String> status, List<String> memberIds, String orderNo, Boolean isDelete, Pageable pageable);

    public Page<OrderMain> findByDateCreatedGreaterThanAndDateCreatedLessThanAndStatusInAndIsDelete(Date startDateCreated, Date endDateCreated, List<String> status, Boolean isDelete, Pageable pageable);

    public Page<OrderMain> findByDateCreatedGreaterThanAndDateCreatedLessThanAndStatusInAndOrderNoAndIsDelete(Date startDateCreated, Date endDateCreated, List<String> status, String orderNo, Boolean isDelete, Pageable pageable);

    public Page<OrderMain> findByDateCreatedGreaterThanAndDateCreatedLessThanAndStatusInAndMemberIdInAndIsDelete(Date startDateCreated, Date endDateCreated, List<String> status, List<String> memberIds, Boolean isDelete, Pageable pageable);

    public Page<OrderMain> findByDateCreatedGreaterThanAndDateCreatedLessThanAndStatusInAndMemberIdInAndOrderNoAndIsDelete(Date startDateCreated, Date endDateCreated, List<String> status, List<String> memberIds, String orderNo, Boolean isDelete, Pageable pageable);


    /**
     * 更新第三方订单号
     *
     * @param id
     * @param thirdOrderNo
     * @return
     */
    @Query(value = "update Order_Main t set t.third_Order_No =?2 where t.id =?1",nativeQuery = true)
    @Transactional
    @Modifying(clearAutomatically = true)
    public int updateThirdOrderNoById(String id, String thirdOrderNo);

    /**
     * 更新第三方订单号
     *
     * @param id
     * @param thirdOrderNo
     * @param orderPrice   更新第三方订单价格
     * @return
     */
    @Query(value = "update Order_Main t set t.third_Order_No =?2 ,t.order_Price=?3 where t.id =?1",nativeQuery = true)
    @Transactional
    @Modifying(clearAutomatically = true)
    public int updateThirdOrderNoById(String id, String thirdOrderNo, BigDecimal orderPrice);

    OrderMain findByThirdOrderNo(String thirdOrderNo);

    OrderMain findByThirdOrderNoAndStoreId(String thirdOrderNo, String storeId);

    //会员中心订单查询
    public Page<OrderMain> findByOrderNoLikeAndStatusInAndMemberIdAndDateCreatedBetweenAndIsDelete(String orderNo, List<String> status, String memberId, Date startDate, Date endDate, Boolean isDelete, Pageable pageable);

    public Page<OrderMain> findByStatusInAndMemberIdAndDateCreatedBetweenAndIsDelete(List<String> status, String memberId, Date startDate, Date endDate, Boolean isDelete, Pageable pageable);

    List<OrderMain> findByStatus(String status);

    List<OrderMain> findByOrganizationIdAndDateCreatedGreaterThanAndDateCreatedLessThanAndStatusInAndIsDeleteOrderByCreateTimeDesc(String organizationId, Date startDateCreated, Date endDateCreated, List<String> status, boolean b);

    List<OrderMain> findByOrganizationIdAndDateCreatedGreaterThanAndDateCreatedLessThanAndStatusInAndOrderNoAndIsDeleteOrderByCreateTimeDesc(String organizationId, Date startDateCreated, Date endDateCreated, List<String> status, String orderNo, boolean b);

    List<OrderMain> findByOrganizationIdAndDateCreatedGreaterThanAndDateCreatedLessThanAndStatusInAndMemberIdInAndIsDeleteOrderByCreateTimeDesc(String organizationId, Date startDateCreated, Date endDateCreated, List<String> status, List<String> memberIds, boolean b);

    List<OrderMain> findByOrganizationIdAndDateCreatedGreaterThanAndDateCreatedLessThanAndStatusInAndMemberIdInAndOrderNoAndIsDeleteOrderByCreateTimeDesc(String organizationId, Date startDateCreated, Date endDateCreated, List<String> status, List<String> memberIds, String orderNo, boolean b);

    List<OrderMain> findByDateCreatedLessThanAndStatusInAndIsDelete(Date date, List<String> status, Boolean isDelete);

    OrderMain findByOrderNoAndMemberId(String orderNo, String memberId);


    List<OrderMain> findByDateCreatedLessThanAndStatusInAndAndSendSmsAndIsDeleteOrSendSmsIsNull(Date date, List<String> status, String sendSms, Boolean isDelete);

    List<OrderMain> findByOrderPriceIsNull();

    @Query("SELECT t FROM OrderMain t join t.subOrders s where s.subOrderNo=?1 ")
    OrderMain findOrderBySubOrderNo(String subOrderNo);


    @Query("SELECT t FROM OrderMain t join t.subOrders s where s.subOrderNo=?1 and t.storeId=?2")
    OrderMain findOrderBySubOrderNoAndProviderId(String subOrderNo, String providerId);


    List<OrderMain> findByOrganizationIdAndStatusInAndIsDelete(String id, List<String> status, boolean b, Pageable pageable);


    List<OrderMain> findByStoreIdAndIsDelete(String storeId, boolean isDelete);

    Long countByMemberIdAndStatusInAndIsDelete(String memberId, List<String> status, boolean isDelete);

    Long countByMemberIdAndStatusInAndIsDeleteAndHaveReview(String memberId, List<String> status, boolean isDelete, boolean haveReview);

    Page<OrderMain> findByOrganizationIdInAndDateCreatedLessThanAndStatusInAndIsDelete(List<String> organizationIds, Date time, List<String> status, boolean isDelete, Pageable pageable);

    Long countByRequestId(String requestId);

    Long countByMemberIdAndStatusInAndIsDeleteAndHaveReviewNot(String memberId, List<String> status, boolean b, boolean c);


    @Query(value = "update Order_Main t set t.first_Audit_Time =?1  where t.id =?2",nativeQuery = true)
    @Transactional
    @Modifying(clearAutomatically = true)
    public int updateOrderFirstAuditTime(Date date, String orderId);

    @Query(value = "update Order_Main t set t.audit_End_Time =?1  where t.id =?2",nativeQuery = true)
    @Transactional
    @Modifying(clearAutomatically = true)
    public int updateOrderAuditEndTime(Date date, String orderId);

    /**
     * @author taofeng
     * @date 2018/5/17
     */
    @Query("select t from OrderMain t where t.status in(1,2,3,4,5,10,12,13,15) and t.createTime between to_date(?1,'yyyy-mm-dd HH24:mi:ss')  and to_date(?2,'yyyy-mm-dd HH24:mi:ss') and t.storeType=?3 and t.organizationId=?4 and t.isDelete=0")
    List<OrderMain> findByBetweenCreatTimeAndStatusAndStoreTypeAndOrganizationId(String startTime, String endTime, String storeType, String organizationId);

    List<OrderMain> findByStatusAndShippingComfirmTimeIsNull(String status);

    List<OrderMain> findByOrganizationIdAndAuditEndTimeIsNotNullAndBillsCreated(String organizationId, Boolean billsCreated);

    /**
     * 获取订单编号
     *
     * @param id id
     * @return orderNo
     */
    @Query("SELECT om.orderNo FROM OrderMain om WHERE om.id = :id")
    String findOrderNoById(@Param("id") String id);

    /**
     * 查询订单状态
     *
     * @param orderNo 订单编号
     * @return orderNo
     */
    @Query("SELECT om.status FROM OrderMain om WHERE om.orderNo = :orderNo")
    String findStatusByOrderNo(@Param("orderNo") String orderNo);

    /**
     * 查询主键
     *
     * @param orderNo 订单编号
     * @return String
     */
    @Query("SELECT om.id FROM OrderMain om WHERE om.orderNo = :orderNo")
    String findIdByOrderNo(@Param("orderNo") String orderNo);

    /**
     * 查询店铺类型
     *
     * @param orderNo 订单编号
     * @return String
     */
    @Query("SELECT om.storeType FROM OrderMain om WHERE om.orderNo = :orderNo")
    String findStoreTypeByOrderNO(@Param("orderNo") String orderNo);

    /**
     * 查询订单地址ID
     *
     * @param orderNo 订单编号
     * @return String
     */
    @Query("SELECT om.addressId FROM OrderMain om WHERE om.orderNo = :orderNo")
    String findAddressIdByOrderNo(@Param("orderNo") String orderNo);

    @Query(value = "update Order_Main t set t.trd_Sp_Status =?1 where t.third_Order_No=?2 and t.store_Id=?3",nativeQuery = true)
    @Transactional()
    @Modifying()
    int updateTrdSpStatus(String trdSpStatus,String trdOrderNo,  String storeId);


}
