package order.model.repository;

import order.model.po.SubOrder;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * Created by xiaoqian on 2016/9/27.
 */
public interface SubOrderRepos extends JpaRepository<SubOrder,String> , JpaSpecificationExecutor<SubOrder>  {


    SubOrder findBySubOrderNo(String subOrderNo);

    @Query(value= "select s from SubOrder s  join  s.order om where s.subOrderNo=?1 and  om.storeId=?2 and rownum<2")
    SubOrder findBySubOrderNoAndProviderId(String subOrderNo, String providerId);


    SubOrder findBySubOrderNoAndTrdSpState(String subOrderNo, String trdSpState);
    List<SubOrder> findBySubOrderNoIn(List<String> subOrderNos);
    @Query(value = "delete from sub_order where order_id =?1",nativeQuery = true)
    @Transactional
    @Modifying(clearAutomatically = true)
    int deleteSubOrdersByOrderMainId(String orderMainId);

 //   @Query(value = "select t.* from sub_order t where t.order_id =?1",nativeQuery = true)
    List<SubOrder> findByOrderId(String orderId);

    /**
     * 批量更新数据
     * @param status
     * @param ids
     * @param lastUpdated
     * @param trdOrderState
     * @return
     */

    @Query(value="update SUB_ORDER t set t.TRD_SP_STATE =?1 ,t.LAST_UPDATED=?3 , t.TRD_ORDER_STATE=?4 where t.ORDER_ID in ( ?2 )",nativeQuery = true)
    @Transactional()
    @Modifying()
    int batchUpdateSubOrderStatusByOrderIds(String status, List<String> ids, Date lastUpdated, String trdOrderState);

    @Query(value="update SUB_ORDER t set t.TRD_ORDER_STATE=?2 where t.ORDER_ID=?1 ",nativeQuery = true)
    @Transactional()
    @Modifying()
    int updateSubOrderState(String orderId,String status);

//    @Query(value="update SubOrder o set o.trdOrderState = :status where o.subOrderNo = :subOrderNo ")
//    @Transactional
//    @Modifying(clearAutomatically=true)
//    int updateSubOrderStatusBySubOrderNo(String subOrderNo, String status);

}
