package order.model.specification;

import order.model.po.MallParentOrder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.List;

/**
 * @author junyang.dong
 * @version v1.0
 * @date 2018/5/9
 */
public class MallParentOrderSpecification<T> implements Specification<T> {
    private MallParentOrder mallParentOrder;

    public MallParentOrderSpecification(MallParentOrder mallParentOrder) {
        this.mallParentOrder = mallParentOrder;
    }

    @Override
    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
        List<Predicate> predicates = new ArrayList<>();
        if (StringUtils.isNoneEmpty(mallParentOrder.getParentOrderNo())) {
            predicates.add(cb.equal(root.get("parentOrderNo"), mallParentOrder.getParentOrderNo()));
        }
        predicates.add(cb.equal(root.get("isDelete"), mallParentOrder.getIsDelete()));
        return query.where(predicates.toArray(new Predicate[predicates.size()])).getRestriction();
    }
}
