package order.model.specification;

import lombok.Data;
import order.model.po.MallTempGoods;
import org.springframework.data.jpa.domain.Specification;
import utils.Lang;

import javax.persistence.criteria.*;
import java.util.ArrayList;
import java.util.List;

/**
 * @author junyang.dong
 * @version v1.0
 * @date 2018/5/9
 */
@Data
public class MallTempGoodsSpecification<T> implements Specification<T> {
    private MallTempGoods mallTempGoods;

    public MallTempGoodsSpecification() {
    }

    public MallTempGoodsSpecification(MallTempGoods mallTempGoods) {
        this.mallTempGoods = mallTempGoods;
    }

    @Override
    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
        List<Predicate> predicates = new ArrayList<>();
        if(!Lang.isEmpty(mallTempGoods)){
            if(!Lang.isEmpty(mallTempGoods.getMallTempOrder())){
                predicates.add(cb.equal(root.get("mallTempOrder").get("id"), mallTempGoods.getMallTempOrder().getId()));
            }
            // 默认使用false
            predicates.add(cb.equal(root.get("isDelete"), false));
        }

        return query.where(predicates.toArray(new Predicate[predicates.size()])).getRestriction();
    }
}
