package payment.model.po;

import com.alibaba.fastjson.annotation.JSONField;
import order.model.po.base.BaseDomain;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * Created by xiaoqian on 2016/9/30.
 */
@Entity
@Table(indexes = {@Index(name = "idx_full_give_store",columnList = "store_id")})
public class FullGive extends BaseDomain implements Serializable {
    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    @Column(length = 36)
    protected String id;

    @Column(length = 36,name = "store_id")
    private String storeId;

    private String name;

    @Column(scale = 2)
    private BigDecimal minTotalMoney;
    @Column(scale = 2)
    private BigDecimal maxTotalMoney;
    @Column(scale = 2)
    private BigDecimal subTractMoney;

    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date startDate;

    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date endDate;

    private Boolean isDisabled;

    private String description;

    private String giftName;

    private String giftDescription;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        FullGive fullGive = (FullGive) o;

        return !(id != null ? !id.equals(fullGive.id) : fullGive.id != null);

    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getStoreId() {
        return storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal getMinTotalMoney() {
        return minTotalMoney;
    }

    public void setMinTotalMoney(BigDecimal minTotalMoney) {
        this.minTotalMoney = minTotalMoney;
    }

    public BigDecimal getMaxTotalMoney() {
        return maxTotalMoney;
    }

    public void setMaxTotalMoney(BigDecimal maxTotalMoney) {
        this.maxTotalMoney = maxTotalMoney;
    }

    public BigDecimal getSubTractMoney() {
        return subTractMoney;
    }

    public void setSubTractMoney(BigDecimal subTractMoney) {
        this.subTractMoney = subTractMoney;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Boolean getIsDisabled() {
        return isDisabled;
    }

    public void setIsDisabled(Boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getGiftName() {
        return giftName;
    }

    public void setGiftName(String giftName) {
        this.giftName = giftName;
    }

    public String getGiftDescription() {
        return giftDescription;
    }

    public void setGiftDescription(String giftDescription) {
        this.giftDescription = giftDescription;
    }
}
