package payment.model.po;

import com.alibaba.fastjson.annotation.JSONField;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Created by xujingfeng on 2016/12/8.
 */
@Entity
public class PayLog implements Serializable {
    /**
     * {@value} 支付状态:待支付
     */
    public final static String PAY_STATUS_WAIT_TO_PAY = "0"; // 待支付
    /**
     * {@value} 支付状态:已支付
     */
    public final static String PAY_STATUS_PAID = "1"; // 已支付

    //对账状态
    /**
     * {@value} 对账状态:已确认
     */
    public final static String P_STATUS_SUCCESS = "2";//已确认
    /**
     * {@value} 对账状态:未匹配
     */
    public final static String P_STATUS_WAIT = "3";//未匹配
    /**
     * {@value} 对账状态:需要处理
     */
    public final static String P_STATUS_FAIL = "4";//需要处理


    @Id
    @Column(name = "id")
    @SequenceGenerator(name = "paylog_id_seq", sequenceName = "paylog_id_seq", allocationSize = 1)
    @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "paylog_id_seq")
    private Integer id;
    /**
     * 第三方平台交易商户订单号,以逗号分隔
     */
    private String orderNo;//
    /**
     * 支付状态，详见<i>"P_STATUS_"</i>开头常量的描述
     */
    @Column(length = 2)
    private String status;
    /**
     * 关联的支付记录，一对多
     */
    @OneToMany(cascade = CascadeType.ALL, mappedBy = "payLog", fetch = FetchType.LAZY)
    private List<Payment> payments; //
    /**
     * 交易流水号 保留
     */
    private String tradeNo;//
    /**
     * 第三方交易流水号
     */
    private String payerTradeNo;//
    /**
     * 支付银行代码
     */
    private String payBank;//
    /**
     * 订单时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date orderTime;//
    /**
     * 支付时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date payTime;//
    /**
     * 订单金额,单位：分
     */
    private String orderAmount;//
    /**
     * 支付金额,单位：分
     */
    private String payAmount;//
    /**
     * 支付结果
     */
    private String payResult;
    /**
     * 合作商户
     */
    private String partner;
    /**
     * 渠道
     */
    private String channel;
    /**
     * 签名
     */
    private String sign;
    /**
     * 对账状态：详见<i>"PAY_STATUS_"</i>开头常量的描述
     */
    private String pstatus;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * 获取 第三方平台交易商户订单号,以逗号分隔
     */
    public String getOrderNo() {
        return this.orderNo;
    }

    /**
     * 设置 第三方平台交易商户订单号,以逗号分隔
     */
    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    /**
     * 获取 支付状态，详见<i>"P_STATUS_"</i>开头常量的描述
     */
    public String getStatus() {
        return this.status;
    }

    /**
     * 设置 支付状态，详见<i>"P_STATUS_"</i>开头常量的描述
     */
    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * 获取 关联的支付记录，一对多
     */
    public List<Payment> getPayments() {
        return this.payments;
    }

    /**
     * 设置 关联的支付记录，一对多
     */
    public void setPayments(List<Payment> payments) {
        this.payments = payments;
    }

    /**
     * 获取 交易流水号 保留
     */
    public String getTradeNo() {
        return this.tradeNo;
    }

    /**
     * 设置 交易流水号 保留
     */
    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    /**
     * 获取 第三方交易流水号
     */
    public String getPayerTradeNo() {
        return this.payerTradeNo;
    }

    /**
     * 设置 第三方交易流水号
     */
    public void setPayerTradeNo(String payerTradeNo) {
        this.payerTradeNo = payerTradeNo;
    }

    /**
     * 获取 支付银行代码
     */
    public String getPayBank() {
        return this.payBank;
    }

    /**
     * 设置 支付银行代码
     */
    public void setPayBank(String payBank) {
        this.payBank = payBank;
    }

    /**
     * 获取 订单时间
     */
    public Date getOrderTime() {
        return this.orderTime;
    }

    /**
     * 设置 订单时间
     */
    public void setOrderTime(Date orderTime) {
        this.orderTime = orderTime;
    }

    /**
     * 获取 支付时间
     */
    public Date getPayTime() {
        return this.payTime;
    }

    /**
     * 设置 支付时间
     */
    public void setPayTime(Date payTime) {
        this.payTime = payTime;
    }

    /**
     * 获取 订单金额,单位：分
     */
    public String getOrderAmount() {
        return this.orderAmount;
    }

    /**
     * 设置 订单金额,单位：分
     */
    public void setOrderAmount(String orderAmount) {
        this.orderAmount = orderAmount;
    }

    /**
     * 获取 支付金额,单位：分
     */
    public String getPayAmount() {
        return this.payAmount;
    }

    /**
     * 设置 支付金额,单位：分
     */
    public void setPayAmount(String payAmount) {
        this.payAmount = payAmount;
    }

    /**
     * 获取 支付结果
     */
    public String getPayResult() {
        return this.payResult;
    }

    /**
     * 设置 支付结果
     */
    public void setPayResult(String payResult) {
        this.payResult = payResult;
    }

    /**
     * 获取 合作商户
     */
    public String getPartner() {
        return this.partner;
    }

    /**
     * 设置 合作商户
     */
    public void setPartner(String partner) {
        this.partner = partner;
    }

    /**
     * 获取 渠道
     */
    public String getChannel() {
        return this.channel;
    }

    /**
     * 设置 渠道
     */
    public void setChannel(String channel) {
        this.channel = channel;
    }

    /**
     * 获取 签名
     */
    public String getSign() {
        return this.sign;
    }

    /**
     * 设置 签名
     */
    public void setSign(String sign) {
        this.sign = sign;
    }

    /**
     * 获取 对账状态：详见<i>"PAY_STATUS_"</i>开头常量的描述
     */
    public String getPstatus() {
        return this.pstatus;
    }

    /**
     * 设置 对账状态：详见<i>"PAY_STATUS_"</i>开头常量的描述
     */
    public void setPstatus(String pstatus) {
        this.pstatus = pstatus;
    }
}
