package payment.model.po;

import order.model.po.base.BaseDomain;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * Created by xiaoqian on 2016/9/28.
 */
@Entity
@Table(indexes = {
        @Index(name = "idx_payment_store", columnList = "store_id")
})
public class Payment extends BaseDomain implements Serializable {
    /**
     * {@value}待支付
     */
    public final static String PAY_STATUS_WAIT_TO_PAY = "0"; // 待支付
    /**
     * {@value}已支付
     */
    public final static String PAY_STATUS_PAID = "1"; // 已支付
    /**
     * {@value}支付出错
     */
    public final static String PAY_STATUS_ERROR = "2"; // 支付出错
    /**
     * {@value}支付出错
     */
    public final static String PAY_STATUS_CANCAL_AND_BACK = "3"; // 支付出错

    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    @Column(length = 36)
    protected String id;

    /**
     * 所使用的支付方式
     */
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "payment_mode_id", foreignKey = @ForeignKey(name = "fk_payment_config"))
    private PaymentConfig config;

    /**
     * 支付类型，付款，退款 等
     */
    @Column(length = 20)
    private String type;

    /**
     * 金额
     */
    @Column(scale = 2)
    private BigDecimal money;

    /**
     * 消耗积分
     */
    @Column(scale = 2)
    private BigDecimal score;

    /**
     * 积分扣减交易凭证号
     */
    @Column(length = 36, name = "rcpt_code")
    private String rcptCode;

    /**
     * 店铺的id
     */
    @Column(length = 36, name = "store_id")
    private String storeId;

    /**
     * 付款用户id
     */
    @Column(length = 36, name = "user_id")
    private String userId;

    /**
     * 支付时使用优惠券id
     */
    @Column(length = 36, name = "soupon_id")
    private String couponId;

    /**
     * 帐户余额使用记录id
     */
    @Column(length = 36, name = "money_his_id")
    private String moneyHisId;

    /**
     * 积分使用id
     */
    @Column(length = 36, name = "credits_his_id")
    private String creditsHisId;

    /**
     * 退款记录id
     */
    @Column(length = 36, name = "return_id")
    private String returnId;

    /**
     * 订单ID
     */
    @Column(length = 36, name = "order_id")
    private String orderId;

    /**
     * 支付状态代码： 0-- 待支付, 1-- 已支付, 2-- 支付出错
     */
    @Column(length = 2)
    private String status;

    /**
     * Payment多对一关联payLog，如果是多订单支付，生成多个payment，一个payLog作为支付平台总账记录
     */
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "pay_log_id", foreignKey = @ForeignKey(name = "fk_payment_pay_log_id"))
    private PayLog payLog;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Payment payment = (Payment) o;
        return !(id != null ? !id.equals(payment.id) : payment.id != null);

    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }

    public String getReturnId() {
        return returnId;
    }

    public void setReturnId(String returnId) {
        this.returnId = returnId;
    }

    public String getStoreId() {
        return storeId;
    }

    public BigDecimal getScore() {
        return score;
    }

    public void setScore(BigDecimal score) {
        this.score = score;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public PaymentConfig getConfig() {
        return config;
    }

    public void setConfig(PaymentConfig config) {
        this.config = config;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public String getCouponId() {
        return couponId;
    }

    public void setCouponId(String couponId) {
        this.couponId = couponId;
    }

    public String getMoneyHisId() {
        return moneyHisId;
    }

    public void setMoneyHisId(String moneyHisId) {
        this.moneyHisId = moneyHisId;
    }

    public String getCreditsHisId() {
        return creditsHisId;
    }

    public void setCreditsHisId(String creditsHisId) {
        this.creditsHisId = creditsHisId;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public PayLog getPayLog() {
        return payLog;
    }

    public void setPayLog(PayLog payLog) {
        this.payLog = payLog;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getRcptCode() {
        return rcptCode;
    }

    public void setRcptCode(String rcptCode) {
        this.rcptCode = rcptCode;
    }
}
