package payment.model.po;

import order.model.po.base.BaseDomain;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;

/**
 * Created by xiaoqian on 2016/9/28.
 */
@Entity
@Table
public class PaymentConfig extends BaseDomain implements Serializable {
    public static String PAYMENT_CONFIG_CODE_PAY_AFTER = "1";	// 后付费
    public static String PAYMENT_CONFIG_CODE_ONLINE = "2";	// 在线支付
    public static String PAYMENT_CONFIG_CODE_TRANSFER = "3";	// 公司转账
    public static String PAYMENT_CONFIG_CODE_CAPITAL = "7";	// 资金转账


    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    @Column(length = 36)
    protected String id;

    @Column(length = 20)
    private String code;

    private String name;

    private String picPath;


    @Column(columnDefinition = "clob")
    private String express;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        PaymentConfig that = (PaymentConfig) o;

        return !(id != null ? !id.equals(that.id) : that.id != null);

    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }

    public String getPicPath() {
        return picPath;
    }

    public void setPicPath(String picPath) {
        this.picPath = picPath;
    }

    public String getExpress() {
        return express;
    }

    public void setExpress(String express) {
        this.express = express;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
