package payment.model.repository;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import payment.model.po.PayLog;

import java.util.List;

/**
 * Created by xujingfeng on 2016/12/8.
 */
public interface PayLogRepos extends JpaRepository<PayLog,Integer>,JpaSpecificationExecutor<PayLog>{
    List<PayLog> findByPayerTradeNo(String payerTradeNo);
    List<PayLog> findByOrderNoAndStatus(String orderNo, String status);


    @Query(value = "update PayLog t set t.pstatus = ?1  where t.payerTradeNo = ?2")
    @Modifying()
    int updatePayLogPstatus(String pstatus, String payerTradeNo);

}
