package payment.model.repository;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;
import payment.model.po.Payment;

import java.util.List;

/**
 * Created by xiaoqian on 2016/9/27.
 */
public interface PaymentRepos extends JpaRepository<Payment,String>,JpaSpecificationExecutor<Payment> {

    public Payment findById(String id);

    @Query(value = "update payment set pay_log_id = ?1 where id = ?2",nativeQuery = true)
    @Modifying(clearAutomatically = true)
    @Transactional
    int updatePaymentPaylogId(Integer payLogId, String id);

    Payment saveAndFlush(Payment payment);

    List<Payment> findByIdIn(List<String> ids);

    List<Payment> findByPayLogId(Integer payLogId);
}
