/*
 * Decompiled with CFR 0.152.
 */
package order.model.po;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import order.model.po.OrderMain;
import order.model.po.OrderParity;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(indexes={@Index(name="idx_order_item_product", columnList="product_id"), @Index(name="idx_order_item_goods", columnList="goods_id"), @Index(name="idx_order_item_fash", columnList="product_fash_id")})
public class OrderItem
implements Serializable {
    public static final String PRODUCT_TYPE_MERCHANDISE = "1";
    public static final String PRODUCT_TYPE_FITTING = "2";
    public static final String PRODUCT_TYPE_GIFT = "3";
    @Id
    @GenericGenerator(name="PKUUID", strategy="uuid2")
    @GeneratedValue(generator="PKUUID")
    @Column(length=36)
    protected String id;
    @ManyToOne
    @JoinColumn(name="order_id", foreignKey=@ForeignKey(name="fk_o_item_order"))
    private OrderMain order;
    @Column(length=36, name="product_id")
    private String productId;
    @Column(length=36, name="goods_id")
    private String goodsId;
    private String productName;
    @Column(length=36, name="product_fash_id")
    private String productFashId;
    private String productType;
    private String productPic;
    private Integer count;
    private Integer returnCount;
    @Column(scale=2)
    private BigDecimal salePrice;
    @Column(scale=2)
    private BigDecimal orginSalePrice;
    @Column(scale=2)
    private BigDecimal memberPrice;
    @Column(scale=2)
    private BigDecimal costPrice;
    @Column(scale=2)
    private BigDecimal finalPrice;
    @Column(scale=2)
    private BigDecimal seckillPrice;
    @Column(scale=2)
    private BigDecimal productPrice;
    @Column(scale=2)
    private BigDecimal salePriceRate;
    private BigDecimal historyCostScore;
    private Boolean isDiscuss = false;
    private String activityId;
    private Boolean isRefund = false;
    private String arriveDate;
    private String sku;
    private String orderLineNumId;
    private String packageNumber;
    private BigDecimal trdSalePrice;
    private String businessCode;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, mappedBy="orderItem")
    private List<OrderParity> orderParities;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="parent")
    private List<OrderItem> children;
    @ManyToOne
    @JoinColumn(name="parent_id")
    private OrderItem parent;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderItem orderItem = (OrderItem)o;
        return !(this.id == null ? orderItem.id != null : !this.id.equals(orderItem.id));
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public BigDecimal getHistoryCostScore() {
        return this.historyCostScore;
    }

    public void setHistoryCostScore(BigDecimal historyCostScore) {
        this.historyCostScore = historyCostScore;
    }

    public Boolean getDiscuss() {
        return this.isDiscuss;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public Integer getReturnCount() {
        return this.returnCount;
    }

    public void setReturnCount(Integer returnCount) {
        this.returnCount = returnCount;
    }

    public String getGoodsId() {
        return this.goodsId;
    }

    public void setGoodsId(String goodsId) {
        this.goodsId = goodsId;
    }

    public BigDecimal getProductPrice() {
        return this.productPrice;
    }

    public void setProductPrice(BigDecimal productPrice) {
        this.productPrice = productPrice;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public OrderMain getOrder() {
        return this.order;
    }

    public void setOrder(OrderMain order) {
        this.order = order;
    }

    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductFashId() {
        return this.productFashId;
    }

    public void setProductFashId(String productFashId) {
        this.productFashId = productFashId;
    }

    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public BigDecimal getSalePrice() {
        return this.salePrice;
    }

    public void setSalePrice(BigDecimal salePrice) {
        this.salePrice = salePrice;
    }

    public BigDecimal getMemberPrice() {
        return this.memberPrice;
    }

    public void setMemberPrice(BigDecimal memberPrice) {
        this.memberPrice = memberPrice;
    }

    public BigDecimal getCostPrice() {
        return this.costPrice;
    }

    public void setCostPrice(BigDecimal costPrice) {
        this.costPrice = costPrice;
    }

    public BigDecimal getFinalPrice() {
        return this.finalPrice;
    }

    public void setFinalPrice(BigDecimal finalPrice) {
        this.finalPrice = finalPrice;
    }

    public BigDecimal getSeckillPrice() {
        return this.seckillPrice;
    }

    public void setSeckillPrice(BigDecimal seckillPrice) {
        this.seckillPrice = seckillPrice;
    }

    public Boolean isDiscuss() {
        return this.isDiscuss;
    }

    public void setDiscuss(Boolean discuss) {
        this.isDiscuss = discuss;
    }

    public Boolean getIsDiscuss() {
        return this.isDiscuss;
    }

    public void setIsDiscuss(Boolean discuss) {
        this.isDiscuss = discuss;
    }

    public String getArriveDate() {
        return this.arriveDate;
    }

    public void setArriveDate(String arriveDate) {
        this.arriveDate = arriveDate;
    }

    public String getOrderLineNumId() {
        return this.orderLineNumId;
    }

    public void setOrderLineNumId(String orderLineNumId) {
        this.orderLineNumId = orderLineNumId;
    }

    public String getPackageNumber() {
        return this.packageNumber;
    }

    public void setPackageNumber(String packageNumber) {
        this.packageNumber = packageNumber;
    }

    public Boolean getIsRefund() {
        return this.isRefund;
    }

    public void setIsRefund(Boolean refund) {
        this.isRefund = refund;
    }

    public Boolean getRefund() {
        return this.isRefund;
    }

    public void setRefund(Boolean refund) {
        this.isRefund = refund;
    }

    public BigDecimal getSalePriceRate() {
        return this.salePriceRate;
    }

    public void setSalePriceRate(BigDecimal salePriceRate) {
        this.salePriceRate = salePriceRate;
    }

    public String getBusinessCode() {
        return this.businessCode;
    }

    public void setBusinessCode(String businessCode) {
        this.businessCode = businessCode;
    }

    public BigDecimal getTrdSalePrice() {
        return this.trdSalePrice;
    }

    public void setTrdSalePrice(BigDecimal trdSalePrice) {
        this.trdSalePrice = trdSalePrice;
    }

    public String getSku() {
        return this.sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public String getProductType() {
        return this.productType;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }

    public String getProductPic() {
        return this.productPic;
    }

    public void setProductPic(String productPic) {
        this.productPic = productPic;
    }

    public List<OrderParity> getOrderParities() {
        return this.orderParities;
    }

    public void setOrderParities(List<OrderParity> orderParities) {
        this.orderParities = orderParities;
    }

    public List<OrderItem> getChildren() {
        return this.children;
    }

    public void setChildren(List<OrderItem> children) {
        this.children = children;
    }

    public OrderItem getParent() {
        return this.parent;
    }

    public void setParent(OrderItem parent) {
        this.parent = parent;
    }

    public BigDecimal getOrginSalePrice() {
        return this.orginSalePrice;
    }

    public void setOrginSalePrice(BigDecimal orginSalePrice) {
        this.orginSalePrice = orginSalePrice;
    }
}

