/*
 * Decompiled with CFR 0.152.
 */
package order.model.specification;

import com.alibaba.fastjson.annotation.JSONField;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import order.model.po.OrderMain;
import org.springframework.data.jpa.domain.Specification;
import utils.Lang;

public class OrderMainSpecification<T>
implements Specification<T> {
    private OrderMain orderMain;
    private List<String> memberIds;
    private List<String> status;
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    private Date createTiemStart;
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    private Date createTiemEnd;

    public OrderMainSpecification() {
    }

    public OrderMainSpecification(OrderMain orderMain) {
        this.orderMain = orderMain;
    }

    public Predicate toPredicate(Root root, CriteriaQuery query, CriteriaBuilder cb) {
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (!Lang.isEmpty((Object)this.orderMain)) {
            CriteriaBuilder.In in;
            if (!Lang.isEmpty((Object)this.orderMain.getOrderNo())) {
                predicates.add(cb.equal((Expression)root.get("orderNo"), (Object)this.orderMain.getOrderNo()));
            }
            if (!Lang.isEmpty(this.memberIds)) {
                in = cb.in((Expression)root.get("memberId"));
                this.memberIds.forEach(memberId -> in.value(memberId));
                predicates.add(in);
            }
            if (!Lang.isEmpty((Object)this.orderMain.getOrganizationId())) {
                predicates.add(cb.equal((Expression)root.get("organizationId"), (Object)this.orderMain.getOrganizationId()));
            }
            if (!Lang.isEmpty(this.status)) {
                in = cb.in((Expression)root.get("status"));
                this.status.forEach(s -> in.value(s));
                predicates.add(in);
            }
            if (!Lang.isEmpty((Object)this.createTiemStart)) {
                predicates.add(cb.greaterThanOrEqualTo((Expression)root.get("dateCreated"), (Comparable)this.createTiemStart));
            }
            if (!Lang.isEmpty((Object)this.createTiemEnd)) {
                predicates.add(cb.lessThanOrEqualTo((Expression)root.get("dateCreated"), (Comparable)this.createTiemEnd));
            }
            if (!Lang.isEmpty((Object)this.orderMain.getParentOrderId())) {
                predicates.add(cb.equal((Expression)root.get("parentOrderId"), (Object)this.orderMain.getParentOrderId()));
            }
        }
        predicates.add(cb.equal((Expression)root.get("isDelete"), (Object)false));
        return query.where(predicates.toArray(new Predicate[predicates.size()])).getRestriction();
    }

    public OrderMain getOrderMain() {
        return this.orderMain;
    }

    public void setOrderMain(OrderMain orderMain) {
        this.orderMain = orderMain;
    }

    public List<String> getMemberIds() {
        return this.memberIds;
    }

    public void setMemberIds(List<String> memberIds) {
        this.memberIds = memberIds;
    }

    public List<String> getStatus() {
        return this.status;
    }

    public void setStatus(List<String> status) {
        this.status = status;
    }

    public Date getCreateTiemStart() {
        return this.createTiemStart;
    }

    public void setCreateTiemStart(Date createTiemStart) {
        this.createTiemStart = createTiemStart;
    }

    public Date getCreateTiemEnd() {
        return this.createTiemEnd;
    }

    public void setCreateTiemEnd(Date createTiemEnd) {
        this.createTiemEnd = createTiemEnd;
    }
}

