/*
 * Decompiled with CFR 0.152.
 */
package payment.model.po;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import order.model.po.base.BaseDomain;
import org.hibernate.annotations.GenericGenerator;
import payment.model.po.PayLog;
import payment.model.po.PaymentConfig;

@Entity
@Table(indexes={@Index(name="idx_payment_store", columnList="store_id")})
public class Payment
extends BaseDomain
implements Serializable {
    public static final String PAY_STATUS_WAIT_TO_PAY = "0";
    public static final String PAY_STATUS_PAID = "1";
    public static final String PAY_STATUS_ERROR = "2";
    public static final String PAY_STATUS_CANCAL_AND_BACK = "3";
    @Id
    @GenericGenerator(name="PKUUID", strategy="uuid2")
    @GeneratedValue(generator="PKUUID")
    @Column(length=36)
    protected String id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="payment_mode_id", foreignKey=@ForeignKey(name="fk_payment_config"))
    private PaymentConfig config;
    @Column(length=20)
    private String type;
    @Column(scale=2)
    private BigDecimal money;
    @Column(scale=2)
    private BigDecimal score;
    @Column(length=36, name="rcpt_code")
    private String rcptCode;
    @Column(length=36, name="store_id")
    private String storeId;
    @Column(length=36, name="user_id")
    private String userId;
    @Column(length=36, name="soupon_id")
    private String couponId;
    @Column(length=36, name="money_his_id")
    private String moneyHisId;
    @Column(length=36, name="credits_his_id")
    private String creditsHisId;
    @Column(length=36, name="return_id")
    private String returnId;
    @Column(length=36, name="order_id")
    private String orderId;
    @Column(length=2)
    private String status;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="pay_log_id", foreignKey=@ForeignKey(name="fk_payment_pay_log_id"))
    private PayLog payLog;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Payment payment = (Payment)o;
        return !(this.id == null ? payment.id != null : !this.id.equals(payment.id));
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String getReturnId() {
        return this.returnId;
    }

    public void setReturnId(String returnId) {
        this.returnId = returnId;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public BigDecimal getScore() {
        return this.score;
    }

    public void setScore(BigDecimal score) {
        this.score = score;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public PaymentConfig getConfig() {
        return this.config;
    }

    public void setConfig(PaymentConfig config) {
        this.config = config;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public BigDecimal getMoney() {
        return this.money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public String getCouponId() {
        return this.couponId;
    }

    public void setCouponId(String couponId) {
        this.couponId = couponId;
    }

    public String getMoneyHisId() {
        return this.moneyHisId;
    }

    public void setMoneyHisId(String moneyHisId) {
        this.moneyHisId = moneyHisId;
    }

    public String getCreditsHisId() {
        return this.creditsHisId;
    }

    public void setCreditsHisId(String creditsHisId) {
        this.creditsHisId = creditsHisId;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public PayLog getPayLog() {
        return this.payLog;
    }

    public void setPayLog(PayLog payLog) {
        this.payLog = payLog;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getRcptCode() {
        return this.rcptCode;
    }

    public void setRcptCode(String rcptCode) {
        this.rcptCode = rcptCode;
    }
}

