package order.service.apiimpl;

import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import order.api.BatchOrderApi;
import order.exceptions.temporder.TempOrderCreateException;
import order.service.service.OrderService;
import order.vo.OrderVo;
import order.vo.TempOrderCreateRequest;
import order.vo.TempOrderVo;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @author Liang Wenxu
 * @since 2018/7/18
 */
@MotanService
public class BatchOrderApiImpl implements BatchOrderApi {

    @Autowired
    private OrderService orderService;
    @Autowired
    private OrderService batchOrderService;

    /**
     * 创建临时订单
     * <p>此接口传入所需购买的所有商品</p>
     *
     * @param tempOrderCreateRequest 只传入客户勾选后的待购商品
     * @return 临时订单实例，如是批量下单、提交的商品中包含不同店铺等需生成多个订单的场景则临时订单会有父子订单，注意与商城展示用的临时订单Vo区分噢
     */
    @Override
    public TempOrderVo newTempOrder(TempOrderCreateRequest tempOrderCreateRequest) {
            TempOrderVo tempOrderVo = null ;
        try {
            tempOrderVo =  batchOrderService.newTempOrder(tempOrderCreateRequest);
        } catch (TempOrderCreateException e) {
            e.printStackTrace();
        }
        return tempOrderVo;
    }

    /**
     * 提交订单，将临时订单提交为真实订单并预占商品库存（如需要）
     * <p>在结算确认页面，用户确认操作后调用，将临时订单确认为真实订单</p>
     *
     * @param tempOrder 临时订单
     * @return 返回OrderVo中将包括订单的简略信息，如需详情请调用OrderQueryApi中相关API进行查询
     */
    @Override
    public OrderVo submit(TempOrderVo tempOrder) {
        return null;
    }
}
